/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iothisk;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.iothisk.model.ActiveRequest;
import com.baidubce.services.iothisk.model.ActiveResponse;
import com.baidubce.services.iothisk.model.AuthRequest;
import com.baidubce.services.iothisk.model.CipherRequest;
import com.baidubce.services.iothisk.model.CipherResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class IotHiskClient
extends AbstractBceClient {
    private static final String ENDPOINT = "hisk.baidubce.com";
    private static final String VERSION = "v1";
    private static final String TSM = "tsm";
    private static final String DEVICE = "device";
    private static final String DECRYPT = "decrypt";
    private static final String ENCRYPT = "encrypt";
    private static final String ACTIVE = "active";
    private static final String AUTH = "auth";
    private static final String[] HEADERS_TO_SIGN = new String[]{"Host"};
    private static final String CONTENT_TYPE = "application/json;charset=UTF-8";
    private static final String NULL_DEVICE_ID = "device id should not be null.";
    private static final String NULL_REQUEST = "request should not be null.";
    private static final HttpResponseHandler[] HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public IotHiskClient(BceClientConfiguration config) {
        super(config.getEndpoint() == null ? config.withEndpoint(ENDPOINT) : config, HANDLERS);
    }

    public CipherResponse encrypt(String deviceId, CipherRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)NULL_REQUEST);
        Preconditions.checkNotNull((Object)deviceId, (Object)NULL_DEVICE_ID);
        InternalRequest internalRequest = this.createTsmDeviceRequest(request, HttpMethodName.POST, deviceId, ENCRYPT);
        return this.invokeHttpClient(internalRequest, CipherResponse.class);
    }

    public CipherResponse decrypt(String deviceId, CipherRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)NULL_REQUEST);
        Preconditions.checkNotNull((Object)deviceId, (Object)NULL_DEVICE_ID);
        InternalRequest internalRequest = this.createTsmDeviceRequest(request, HttpMethodName.POST, deviceId, DECRYPT);
        return this.invokeHttpClient(internalRequest, CipherResponse.class);
    }

    public ActiveResponse active(String deviceId, ActiveRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)NULL_REQUEST);
        Preconditions.checkNotNull((Object)deviceId, (Object)NULL_DEVICE_ID);
        InternalRequest internalRequest = this.createTsmDeviceRequest(request, HttpMethodName.POST, deviceId, ACTIVE);
        return this.invokeHttpClient(internalRequest, ActiveResponse.class);
    }

    public void auth(String deviceId, AuthRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)NULL_REQUEST);
        Preconditions.checkNotNull((Object)deviceId, (Object)NULL_DEVICE_ID);
        InternalRequest internalRequest = this.createTsmDeviceRequest(request, HttpMethodName.POST, deviceId, AUTH);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    private InternalRequest createTsmDeviceRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String deviceId, String action) {
        ArrayList<String> path = new ArrayList<String>();
        path.addAll(Arrays.asList(VERSION, TSM, DEVICE));
        return this.createRequest(bceRequest, httpMethod, null, path, deviceId, action);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, SignOptions signOptions, List<String> path, String ... pathVariables) {
        if (path == null) {
            path = new ArrayList<String>();
        }
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        if (signOptions == null) {
            signOptions = new SignOptions();
            signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        if (httpMethod == HttpMethodName.PUT || httpMethod == HttpMethodName.POST) {
            IotHiskClient.fillInHeaderAndBody(bceRequest, request);
        }
        return request;
    }

    private static void fillInHeaderAndBody(AbstractBceRequest bceRequest, InternalRequest request) {
        byte[] content = IotHiskClient.toJson(bceRequest);
        request.addHeader("Content-Length", Integer.toString(content.length));
        request.addHeader("Content-Type", CONTENT_TYPE);
        request.setContent(RestartableInputStream.wrap(content));
    }

    private static byte[] toJson(AbstractBceRequest request) {
        String jsonStr = JsonUtils.toJsonString(request);
        try {
            return jsonStr.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
    }
}

