/*
 * Copyright (c) 2020 Baidu.com, Inc. All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.bec.model.vm.instance;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.bec.model.vm.KeyConfig;
import com.baidubce.services.bec.model.vm.image.Image;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import java.util.List;

/**
 * The request for reinstalling the BEC virtual machine system.
 */
@Data
public class ReinstallBecVmInstanceRequest extends AbstractBceRequest {

    /**
     * The id of the BEC virtual machine system.
     */
    private String vmID;

    /**
     * Password.
     */
    @Deprecated
    private String adminPass;

    /**
     * The new way to configure password and key.
     */
    private KeyConfig keyConfig;

    /**
     * Image id.
     * worked with imageType, be marked on 24.11.
     */
    private String imageId;

    /**
     * Image type, image type must be [bec|bcc|rds]
     * worked with imageId.
     */
    private String imageType;

    /**
     * Data volume image info.
     */
    private List<Image> images;

    /**
     * Reset data disk.
     */
    private Boolean resetDataDisk;

    /**
     * The host name of the virtual machine.
     */
    private String hostname;

    /**
     * The userData of the virtual machine.
     * <p>
     * The custom injected data, user need to encode the original text using base64.  The encoding formula :
     * base64(user_injected_data: base64(original text))
     */
    private String userData;

    /**
     * The cuda version of the virtual machine.
     */
    private String cudaVersion;

    /**
     * The driver version of the virtual machine.
     */
    private String driverVersion;

    /**
     * The cuDNN version of the virtual machine.
     */
    private String cudnnVersion;

    /**
     * An ASCII string whose length is less than 64.
     * <p>
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BEC/API.html">
     * BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;

    /**
     * Configure request credential for the request.
     *
     * @param credentials a valid instance of BceCredentials.
     * @return ReinstallBecVmInstanceRequest with credentials.
     */
    public ReinstallBecVmInstanceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
