/*
 * Copyright (c) 2020 Baidu.com, Inc. All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.bec.model.vm.service;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.bec.model.purchase.AutoRenew;
import com.baidubce.services.bec.model.purchase.DeploymentInstance;
import com.baidubce.services.bec.model.vm.DnsConfig;
import com.baidubce.services.bec.model.vm.KeyConfig;
import com.baidubce.services.bec.model.vm.NetworkConfig;
import com.baidubce.services.bec.model.vm.SystemVolumeConfig;
import com.baidubce.services.bec.model.vm.VolumeConfig;
import com.baidubce.services.tag.model.Tag;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Builder;
import lombok.Data;

import java.util.List;

/**
 * The request for creating a newly vm service.
 * Shared with creating vm instances.
 */
@Data
@Builder
public class CreateBecVmServiceRequest extends AbstractBceRequest {

    /**
     * The id of the service.
     */
    private String serviceId;

    /**
     * The name of the service.
     */
    private String serviceName;

    /**
     * The name of the vm.
     */
    private String vmName;

    /**
     * TemplateId.
     */
    private String templateId;

    /**
     * Password.
     */
    @Deprecated
    private String adminPass;

    /**
     * The payment method of the service.
     */
    private String paymentMethod;

    /**
     * The prepayment reservation configuration of the virtual machine service
     */
    private Reservation reservation;

    /**
     * The autoRenew configuration.
     */
    private AutoRenew autoRenew;

    /**
     * Whether the vm service need public ip.
     */
    private Boolean needPublicIp;

    /**
     * Whether the vm service need public ipv6.
     */
    private Boolean needIpv6PublicIp;

    /**
     * Disable Intra net.
     */
    private Boolean disableIntranet;

    /**
     * Disable Cloud Init.
     */
    private Boolean disableCloudInit;

    /**
     * The bandwidth of the service.
     */
    private Integer bandwidth;

    /**
     * List of deployment instances.
     */
    private List<DeploymentInstance> deployInstances;

    /**
     * The cpu of the service.
     */
    private Integer cpu;

    /**
     * The memory of the service.
     */
    private Integer memory;

    /**
     * The imageId of the service.
     */
    private String imageId;

    /**
     * The imageType of the service.
     */
    private String imageType;

    /**
     * Data disk configuration list.
     */
    private List<VolumeConfig> dataVolumeList;

    /**
     * System disk configuration information.
     */
    private SystemVolumeConfig systemVolume;

    /**
     * The keyConfig of the vm service.
     */
    private KeyConfig keyConfig;

    /**
     * The specification of the vm service.
     */
    private String spec;

    /**
     * The hostname of the vm service.
     */
    private String hostname;

    /**
     * The network config list of the virtual machine service.
     */
    private List<NetworkConfig> networkConfigList;

    /**
     * The dns configuration of the virtual machine service.
     */
    private DnsConfig dnsConfig;

    /**
     * The security group ids of the vm.
     */
    private List<String> securityGroupIds;

    /**
     * The user script of the vm.
     * <p>
     * The custom injected data, user need to encode the original text using base64.  The encoding formula :
     * base64(user_injected_data: base64(original text))
     */
    private String userData;

    /**
     * The cuda version of the virtual machine.
     */
    private String cudaVersion;

    /**
     * The driver version of the virtual machine.
     */
    private String driverVersion;

    /**
     * The cuDNN version of the virtual machine.
     */
    private String cudnnVersion;

    /**
     * The deployment set ids of the vm service.
     */
    private List<String> deploysetIdList;

    /**
     * The tags of the virtual machine.
     */
    private List<Tag> tags;

    /**
     * An ASCII string whose length is less than 64.
     * <p>
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BEC/API.html">
     * BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;

    /**
     * Configure request credential for the request.
     *
     * @param credentials a valid instance of BceCredentials.
     * @return GetInstanceRequest with credentials.
     */
    @Override
    public CreateBecVmServiceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
