package com.baidubce.services.etgateway.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.List;

@Getter
@Setter
@Accessors(chain = true)
public class UpdateEtGatewayRequest extends AbstractBceRequest {
    /**
     * An ASCII string whose length is less than 64.
     * <p>
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     * BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;


    private String etGatewayId;

    /**
     * The name of the dedicated line gateway, composed of uppercase and lowercase letters, numbers,
     * and special characters -_ /. Must start with a letter and have a length of 1-65 characters
     */
    private String name;

    /**
     * The speed limit value of the dedicated line gateway bandwidth, measured in Mbps.
     * The limit is an integer between 2 and 10000.
     */
    private Integer speed;

    /**
     * The description of the dedicated line gateway, not exceeding 200 characters
     */
    private String description;

    /**
     * The cloud-side network of the dedicated line gateway.
     * Users can choose the local VPC subnet or define one or more custom subnets.
     * This setting is only applicable when parameters etId and channelId exist
     */
    private List<String> localCidrs;

    /**
     * Whether IPv6 functionality is enabled, 1 for yes, 0 for no.
     */
    private Integer enableIpv6;

    /**
     * IPv6 cloud-side network
     */
    private List<String> ipv6LocalCidrs;

    @Override
    public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
