package com.baidubce.services.localdns.model;

import com.baidubce.common.BaseBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ListRecordRequest extends BaseBceRequest {

    /**
     * 查询的域名ID
     */
    private String zoneId;
    /**
     * 标记查询的起始位置
     */
    private String marker;

    /**
     * 查询记录的最大数量，取值范围为1-1000
     */
    private Integer maxKeys;

    public String getZoneId() {
        return zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public String getMarker() {
        return marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public Integer getMaxKeys() {
        return maxKeys;
    }

    public void setMaxKeys(Integer maxKeys) {
        this.maxKeys = maxKeys;
    }

    @Override
    public String toString() {
        return "ListRecordRequest{"
                + "zoneId=" + zoneId + "\n"
                + "marker=" + marker + "\n"
                + "maxKeys=" + maxKeys
                + "}";

    }
}
