/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.examples.csn;

import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.csn.CsnClient;
import com.baidubce.services.csn.model.CreateCsnBpRequest;
import com.baidubce.services.csn.model.CreateCsnBpResponse;
import com.baidubce.services.tag.model.Tag;
import com.google.common.collect.Lists;
import java.util.UUID;

public class ExampleCreateCsnBp {
    public static void main(String[] args) {
        String ak = "Your Ak";
        String sk = "Your Sk";
        String endpoint = "csn.baidubce.com";
        BceClientConfiguration config = new BceClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ak, sk));
        config.setEndpoint(endpoint);
        CsnClient csnClient = new CsnClient(config);
        CreateCsnBpRequest.Billing.Reservation reservation = CreateCsnBpRequest.Billing.Reservation.builder().reservationTimeUnit("month").reservationLength(1).build();
        CreateCsnBpRequest.Billing prepaidBilling = CreateCsnBpRequest.Billing.builder().paymentTiming("Prepaid").reservation(reservation).build();
        String interWorkType = "center";
        CreateCsnBpRequest prepaidCreateCsnBpRequest = CreateCsnBpRequest.builder().name("prepaidCsnBpTest").bandwidth(100).geographicA("China").geographicB("China").interworkType(interWorkType).billing(prepaidBilling).tags(Lists.newArrayList((Object[])new Tag[]{new Tag().withTagKey("test").withTagValue("test")})).build();
        String prepaidClientToken = UUID.randomUUID().toString();
        try {
            CreateCsnBpResponse prepaidCsnBp = csnClient.createCsnBp(prepaidCreateCsnBpRequest, prepaidClientToken);
            System.out.println("prepaidCsnBp = " + prepaidCsnBp);
        }
        catch (BceClientException e) {
            System.out.println(e.getMessage());
        }
        CreateCsnBpRequest.Billing postpaidBilling = CreateCsnBpRequest.Billing.builder().paymentTiming("Postpaid").build();
        CreateCsnBpRequest postpaidCreateCsnBpRequest = CreateCsnBpRequest.builder().name("postpaidCsnBpTest").bandwidth(100).geographicA("China").geographicB("China").interworkType(interWorkType).billing(postpaidBilling).tags(Lists.newArrayList((Object[])new Tag[]{new Tag().withTagKey("test").withTagValue("test")})).build();
        String postpaidClientToken = UUID.randomUUID().toString();
        try {
            CreateCsnBpResponse postpaidCsnBp = csnClient.createCsnBp(postpaidCreateCsnBpRequest, postpaidClientToken);
            System.out.println("postpaidCsnBp = " + postpaidCsnBp);
        }
        catch (BceClientException e) {
            System.out.println(e.getMessage());
        }
    }
}

