/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.examples.peerconn;

import com.baidubce.BceClientException;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.bcc.model.TagModel;
import com.baidubce.services.eip.model.Billing;
import com.baidubce.services.peerconn.PeerConnClient;
import com.baidubce.services.peerconn.PeerConnClientConfiguration;
import com.baidubce.services.peerconn.model.CreatePeerConnRequest;
import com.baidubce.services.peerconn.model.CreatePeerConnResponse;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;

public class ExampleCreatePeerConn {
    public static void main(String[] args) {
        String ak = "Your Ak";
        String sk = "Your Sk";
        String endpoint = "bcc.bj.baidubce.com";
        PeerConnClientConfiguration config = new PeerConnClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ak, sk));
        config.setEndpoint(endpoint);
        PeerConnClient peerConnClient = new PeerConnClient(config);
        CreatePeerConnRequest createPeerConnRequest = new CreatePeerConnRequest();
        createPeerConnRequest.setBandwidthInMbps(500);
        createPeerConnRequest.setDescription("java sdk test peer conn.");
        createPeerConnRequest.setLocalIfName("peer_conn_local");
        createPeerConnRequest.setLocalVpcId("vpc-nteqxm76n65t");
        createPeerConnRequest.setPeerAccountId("PeerAccountId");
        createPeerConnRequest.setPeerVpcId("vpc-z9new983u7ne");
        createPeerConnRequest.setPeerRegion("su");
        createPeerConnRequest.setPeerIfName("peer_conn_peer");
        createPeerConnRequest.setDeleteProtect(true);
        Billing.Reservation reservation = new Billing.Reservation();
        reservation.setReservationLength(1);
        reservation.setReservationTimeUnit("month");
        Billing billing = new Billing();
        billing.setPaymentTiming("Prepaid");
        billing.setReservation(reservation);
        createPeerConnRequest.setBilling(billing);
        ArrayList tags = Lists.newArrayList((Object[])new TagModel[]{new TagModel().withTagKey("testKey").withTagValue("testValue")});
        createPeerConnRequest.setTags(tags);
        createPeerConnRequest.setClientToken(UUID.randomUUID().toString());
        try {
            CreatePeerConnResponse createPeerConnResponse = peerConnClient.createPeerConn(createPeerConnRequest);
            System.out.println("createPeerConnResponse = " + createPeerConnResponse);
        }
        catch (BceClientException e) {
            System.out.println(e.getMessage());
        }
    }
}

