/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.batch;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.batch.model.CancelJobRequest;
import com.baidubce.services.batch.model.CreateJobRequest;
import com.baidubce.services.batch.model.CreateJobResponse;
import com.baidubce.services.batch.model.GetJobRequest;
import com.baidubce.services.batch.model.GetJobResponse;
import com.baidubce.services.batch.model.ListJobsRequest;
import com.baidubce.services.batch.model.ListJobsResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class BatchClient
extends AbstractBceClient {
    private static final String VERSION = "v1";
    private static final String JOB = "job";
    private static final String[] HEADERS_TO_SIGN = new String[]{"host", "x-bce-date"};
    private static final HttpResponseHandler[] BATCH_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public BatchClient() {
        this(new BceClientConfiguration());
    }

    public BatchClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, BATCH_HANDLERS);
    }

    public ListJobsResponse listJobs(ListJobsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, JOB);
        if (request.getMarker() != null) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() >= 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        return this.invokeHttpClient(internalRequest, ListJobsResponse.class);
    }

    public ListJobsResponse listJobs() {
        return this.listJobs(new ListJobsRequest());
    }

    public ListJobsResponse listJobs(int maxKeys) {
        return this.listJobs(new ListJobsRequest().withMaxKeys(maxKeys));
    }

    public ListJobsResponse listJobs(String marker, int maxKeys) {
        return this.listJobs(new ListJobsRequest().withMaxKeys(maxKeys).withMarker(marker));
    }

    public GetJobResponse getJob(GetJobRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getJobId(), "The parameter jobId should not be null or empty string.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, JOB, request.getJobId());
        return this.invokeHttpClient(internalRequest, GetJobResponse.class);
    }

    public GetJobResponse getJob(String jobId) {
        return this.getJob(new GetJobRequest().withJobId(jobId));
    }

    public CreateJobResponse createJob(CreateJobRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getName(), "The name should not be null or empty string.");
        Validate.checkStringNotEmpty(request.getVmType(), "The vmType should not be null or empty string.");
        Validate.checkStringNotEmpty(request.getJobDagJson(), "The jobDagJson should not be null or empty string.");
        Validate.checkIsTrue(request.getVmCount() > 0, "The vmCount should greater than 0");
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("name", request.getName());
            jsonGenerator.writeStringField("vmType", request.getVmType());
            jsonGenerator.writeNumberField("vmCount", request.getVmCount());
            jsonGenerator.writeStringField("jobDagJson", request.getJobDagJson());
            if (request.getJobTimeoutInSeconds() != null) {
                jsonGenerator.writeNumberField("jobTimeoutInSeconds", request.getJobTimeoutInSeconds().intValue());
            }
            if (request.getMemo() != null) {
                jsonGenerator.writeStringField("memo", request.getMemo());
            }
            jsonGenerator.writeEndObject();
            jsonGenerator.close();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        byte[] json = null;
        try {
            json = writer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, JOB);
        internalRequest.addHeader("Content-Length", String.valueOf(json.length));
        internalRequest.addHeader("Content-Type", "application/json");
        internalRequest.setContent(RestartableInputStream.wrap(json));
        internalRequest.addParameter("run", "immediate");
        if (request.getClientToken() != null) {
            internalRequest.addParameter("clientToken", request.getClientToken());
        }
        return this.invokeHttpClient(internalRequest, CreateJobResponse.class);
    }

    public void cancelJob(CancelJobRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getJobId(), "The parameter jobId should not be null or empty string.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, JOB, request.getJobId());
        internalRequest.addParameter("cancel", null);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void cancelJob(String jobId) {
        this.cancelJob(new CancelJobRequest().withJobId(jobId));
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }
}

