/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.et;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.BceCredentials;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.et.EtClientConfiguration;
import com.baidubce.services.et.model.ApplyForEtRequest;
import com.baidubce.services.et.model.ApplyForEtResponse;
import com.baidubce.services.et.model.AssociateEtChannelRequest;
import com.baidubce.services.et.model.CreateEtChannelRequest;
import com.baidubce.services.et.model.CreateEtChannelResponse;
import com.baidubce.services.et.model.CreateEtChannelRouteResponse;
import com.baidubce.services.et.model.CreateEtChannelRouteRuleRequest;
import com.baidubce.services.et.model.DisassociateEtChannelRequest;
import com.baidubce.services.et.model.EnableEtChannelIpv6Request;
import com.baidubce.services.et.model.Et;
import com.baidubce.services.et.model.EtChannelIdRequest;
import com.baidubce.services.et.model.EtChannelRouteRuleIdRequest;
import com.baidubce.services.et.model.ListEtChannelRouteRulesRequest;
import com.baidubce.services.et.model.ListEtChannelRouteRulesResponse;
import com.baidubce.services.et.model.ListEtChannelsResponse;
import com.baidubce.services.et.model.ListEtRequest;
import com.baidubce.services.et.model.ListEtResponse;
import com.baidubce.services.et.model.ResubmitEtChannelRequest;
import com.baidubce.services.et.model.UpdateEtChannelRequest;
import com.baidubce.services.et.model.UpdateEtChannelRouteRuleRequest;
import com.baidubce.services.et.model.UpdateEtRequest;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtClient
extends AbstractBceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtClient.class);
    private static final String VERSION = "v1";
    private static final String ET_PREFIX = "et";
    private static final String ET_CHANNEL_PREFIX = "channel";
    private static final String ET_CHANNEL_ROUTE_PREFIX = "route/rule";
    private static final String ET_CHANNEL_ASSOCIATE_PREFIX = "associate";
    private static final String ET_CHANNEL_DISASSOCIATE_PREFIX = "disassociate";
    private static final String CLIENT_TOKEN = "clientToken";
    private static final HttpResponseHandler[] ET_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public EtClient() {
        this(new EtClientConfiguration());
    }

    public EtClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, ET_HANDLERS);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            byte[] requestJson;
            String strJson = JsonUtils.toJsonString(bceRequest);
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    public ApplyForEtResponse applyForEt(ApplyForEtRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getName(), "name should not be empty");
        Validate.checkStringNotEmpty(request.getIsp(), "isp should not be empty");
        Validate.checkStringNotEmpty(request.getIntfType(), "intfType should not be empty");
        Validate.checkStringNotEmpty(request.getApType(), "apType should not be empty");
        Validate.checkStringNotEmpty(request.getApAddr(), "apAddr should not be empty");
        Validate.checkStringNotEmpty(request.getUserIdc(), "userIdc should not be empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, "et/init");
        if (StringUtils.isNotBlank((String)request.getClientToken())) {
            internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        }
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, ApplyForEtResponse.class);
    }

    public void updateEt(UpdateEtRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getEtId(), "request etId should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ET_PREFIX, request.getEtId());
        if (StringUtils.isNotBlank((String)request.getClientToken())) {
            internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        }
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListEtResponse listEts(ListEtRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, ET_PREFIX);
        if (StringUtils.isNotBlank((String)request.getMarker())) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        if (StringUtils.isNotBlank((String)request.getStatus())) {
            internalRequest.addParameter("status", request.getStatus());
        }
        return this.invokeHttpClient(internalRequest, ListEtResponse.class);
    }

    public Et getEtDetail(String etId) {
        Validate.checkStringNotEmpty(etId, "etId should not be empty");
        InternalRequest internalRequest = this.createRequest(new AbstractBceRequest(){

            @Override
            public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
                this.setRequestCredentials(credentials);
                return this;
            }
        }, HttpMethodName.GET, ET_PREFIX, etId);
        return this.invokeHttpClient(internalRequest, Et.class);
    }

    public CreateEtChannelResponse createEtChannel(CreateEtChannelRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getEtId(), "etId should not be empty");
        Validate.checkStringNotEmpty(request.getBaiduAddress(), "baiduAddress should not be empty");
        Validate.checkStringNotEmpty(request.getName(), "name should not be empty");
        Validate.checkStringNotEmpty(request.getCustomerAddress(), "customerAddress should not be empty");
        Validate.checkStringNotEmpty(request.getRouteType(), "routeType should not be empty");
        Preconditions.checkNotNull((Object)request.getVlanId(), (Object)"vlanId should not be empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, ET_PREFIX, request.getEtId(), ET_CHANNEL_PREFIX);
        if (StringUtils.isNotBlank((String)request.getClientToken())) {
            internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        }
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateEtChannelResponse.class);
    }

    public ListEtChannelsResponse listEtChannels(String etId) {
        Validate.checkStringNotEmpty(etId, "etId should not be empty");
        InternalRequest internalRequest = this.createRequest(new AbstractBceRequest(){

            @Override
            public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
                this.setRequestCredentials(credentials);
                return this;
            }
        }, HttpMethodName.GET, ET_PREFIX, etId, ET_CHANNEL_PREFIX);
        return this.invokeHttpClient(internalRequest, ListEtChannelsResponse.class);
    }

    public void resubmitEtChannel(ResubmitEtChannelRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getEtId(), "etId should not be empty");
        Validate.checkStringNotEmpty(request.getEtChannelId(), "etChannelId should not be empty");
        Validate.checkStringNotEmpty(request.getBaiduAddress(), "baiduAddress should not be empty");
        Validate.checkStringNotEmpty(request.getName(), "name should not be empty");
        Validate.checkStringNotEmpty(request.getCustomerAddress(), "customerAddress should not be empty");
        Validate.checkStringNotEmpty(request.getRouteType(), "routeType should not be empty");
        Preconditions.checkNotNull((Object)request.getVlanId(), (Object)"vlanId should not be empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ET_PREFIX, request.getEtId(), ET_CHANNEL_PREFIX, request.getEtChannelId());
        internalRequest.addParameter("reCreate", null);
        if (StringUtils.isNotBlank((String)request.getClientToken())) {
            internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        }
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateEtChannel(UpdateEtChannelRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getEtId(), "etId should not be empty");
        Validate.checkStringNotEmpty(request.getEtChannelId(), "etChannelId should not be empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ET_PREFIX, request.getEtId(), ET_CHANNEL_PREFIX, request.getEtChannelId());
        internalRequest.addParameter("modifyAttribute", null);
        if (StringUtils.isNotBlank((String)request.getClientToken())) {
            internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        }
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteEtChannel(EtChannelIdRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getEtId(), "etId should not be empty");
        Validate.checkStringNotEmpty(request.getEtChannelId(), "etChannelId should not be empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, ET_PREFIX, request.getEtId(), ET_CHANNEL_PREFIX, request.getEtChannelId());
        if (StringUtils.isNotBlank((String)request.getClientToken())) {
            internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        }
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void enableEtChannelIpv6(EnableEtChannelIpv6Request request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getEtId(), "etId should not be empty");
        Validate.checkStringNotEmpty(request.getEtChannelId(), "etChannelId should not be empty");
        Validate.checkStringNotEmpty(request.getBaiduIpv6Address(), "baiduIpv6Address should not be empty");
        Validate.checkStringNotEmpty(request.getCustomerIpv6Address(), "customerIpv6Address should not be empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ET_PREFIX, request.getEtId(), ET_CHANNEL_PREFIX, request.getEtChannelId());
        internalRequest.addParameter("enableIpv6", null);
        if (StringUtils.isNotBlank((String)request.getClientToken())) {
            internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        }
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void disableEtChannelIpv6(EtChannelIdRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getEtId(), "etId should not be empty");
        Validate.checkStringNotEmpty(request.getEtChannelId(), "etChannelId should not be empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ET_PREFIX, request.getEtId(), ET_CHANNEL_PREFIX, request.getEtChannelId());
        internalRequest.addParameter("disableIpv6", null);
        if (StringUtils.isNotBlank((String)request.getClientToken())) {
            internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        }
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public CreateEtChannelRouteResponse createEtChannelRouteRule(CreateEtChannelRouteRuleRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getEtId(), "etId should not be empty");
        Validate.checkStringNotEmpty(request.getEtChannelId(), "etChannelId should not be empty");
        Validate.checkStringNotEmpty(request.getDestAddress(), "destAddress should not be empty");
        Validate.checkStringNotEmpty(request.getNexthopType(), "nexthopType should not be empty");
        Validate.checkStringNotEmpty(request.getNexthopId(), "nexthopId should not be empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, ET_PREFIX, request.getEtId(), ET_CHANNEL_PREFIX, request.getEtChannelId(), ET_CHANNEL_ROUTE_PREFIX);
        if (StringUtils.isNotBlank((String)request.getClientToken())) {
            internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        }
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateEtChannelRouteResponse.class);
    }

    public ListEtChannelRouteRulesResponse listEtChannelRouteRules(ListEtChannelRouteRulesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getEtId(), "etId should not be empty");
        Validate.checkStringNotEmpty(request.getEtChannelId(), "etChannelId should not be empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, ET_PREFIX, request.getEtId(), ET_CHANNEL_PREFIX, request.getEtChannelId(), ET_CHANNEL_ROUTE_PREFIX);
        if (StringUtils.isNotBlank((String)request.getMarker())) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        if (StringUtils.isNotBlank((String)request.getDestAddress())) {
            internalRequest.addParameter("destAddress", request.getDestAddress());
        }
        return this.invokeHttpClient(internalRequest, ListEtChannelRouteRulesResponse.class);
    }

    public void updateEtChannelRouteRule(UpdateEtChannelRouteRuleRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getEtId(), "etId should not be empty");
        Validate.checkStringNotEmpty(request.getEtChannelId(), "etChannelId should not be empty");
        Validate.checkStringNotEmpty(request.getRouteRuleId(), "routeRuleId should not be empty");
        Preconditions.checkNotNull((Object)request.getDescription(), (Object)"description should not be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ET_PREFIX, request.getEtId(), ET_CHANNEL_PREFIX, request.getEtChannelId(), ET_CHANNEL_ROUTE_PREFIX, request.getRouteRuleId());
        if (StringUtils.isNotBlank((String)request.getClientToken())) {
            internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        }
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteEtRouteRule(EtChannelRouteRuleIdRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getEtId(), "etId should not be empty");
        Validate.checkStringNotEmpty(request.getEtChannelId(), "etChannelId should not be empty");
        Validate.checkStringNotEmpty(request.getRouteRuleId(), "routeRuleId should not be empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, ET_PREFIX, request.getEtId(), ET_CHANNEL_PREFIX, request.getEtChannelId(), ET_CHANNEL_ROUTE_PREFIX, request.getRouteRuleId());
        if (StringUtils.isNotBlank((String)request.getClientToken())) {
            internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        }
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void associateEtChannel(AssociateEtChannelRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getEtId(), "etId should not be empty");
        Validate.checkStringNotEmpty(request.getEtChannelId(), "etChannelId should not be empty");
        Validate.checkStringNotEmpty(request.getExtraChannelId(), "extraChannelId should not be empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ET_PREFIX, request.getEtId(), ET_CHANNEL_PREFIX, request.getEtChannelId());
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(ET_CHANNEL_ASSOCIATE_PREFIX, null);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void disassociateEtChannel(DisassociateEtChannelRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getEtId(), "etId should not be empty");
        Validate.checkStringNotEmpty(request.getEtChannelId(), "etChannelId should not be empty");
        Validate.checkStringNotEmpty(request.getExtraChannelId(), "extraChannelId should not be empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ET_PREFIX, request.getEtId(), ET_CHANNEL_PREFIX, request.getEtChannelId());
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(ET_CHANNEL_DISASSOCIATE_PREFIX, null);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }
}

