/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.ipcollection;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.ipcollection.IpCollectionClientConfiguration;
import com.baidubce.services.ipcollection.emum.IpCollectionAction;
import com.baidubce.services.ipcollection.model.ipgroup.BindIpSetRequest;
import com.baidubce.services.ipcollection.model.ipgroup.CreateIpAddressGroupRequest;
import com.baidubce.services.ipcollection.model.ipgroup.CreateIpAddressGroupResponse;
import com.baidubce.services.ipcollection.model.ipgroup.DeleteIpGroupRequest;
import com.baidubce.services.ipcollection.model.ipgroup.QueryIpGroupDetailRequest;
import com.baidubce.services.ipcollection.model.ipgroup.QueryIpGroupDetailResponse;
import com.baidubce.services.ipcollection.model.ipgroup.QueryIpGroupListRequest;
import com.baidubce.services.ipcollection.model.ipgroup.QueryIpGroupListResponse;
import com.baidubce.services.ipcollection.model.ipgroup.UnBindIpSetRequest;
import com.baidubce.services.ipcollection.model.ipgroup.UpdateIpGroupRequest;
import com.baidubce.services.ipcollection.model.ipset.AddIpAddressToIpSetRequest;
import com.baidubce.services.ipcollection.model.ipset.CreateIpAddressSetRequest;
import com.baidubce.services.ipcollection.model.ipset.CreateIpAddressSetResponse;
import com.baidubce.services.ipcollection.model.ipset.DeleteIpSetRequest;
import com.baidubce.services.ipcollection.model.ipset.QueryIpSetDetailRequest;
import com.baidubce.services.ipcollection.model.ipset.QueryIpSetDetailResponse;
import com.baidubce.services.ipcollection.model.ipset.QueryIpSetListRequest;
import com.baidubce.services.ipcollection.model.ipset.QueryIpSetListResponse;
import com.baidubce.services.ipcollection.model.ipset.RemoveIpAddressFromIpSetRequest;
import com.baidubce.services.ipcollection.model.ipset.UpdateIpSetRequest;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.StringFormatUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;

public class IpCollectionClient
extends AbstractBceClient {
    private static final String VERSION = "v1";
    private static final String[] HEADERS_TO_SIGN = new String[]{"host", "x-bce-date"};
    private static final String CLIENT_TOKEN = "clientToken";
    private static final String QUERY_MAX_KEYS_VALUE = "1000";
    private static final String IP_SET_URL_PREFIX = "ipSet";
    private static final String IP_GROUP_URL_PREFIX = "ipGroup";
    private static final String IP_ADDRESS = "ipAddress";
    private static final String DELETE_IP_ADDRESS = "deleteIpAddress";
    private static final String MARKER = "marker";
    private static final String MAX_KEYS = "maxKeys";
    private static final String REQUEST_NULL_ERROR_MESSAGE = "request should not be null.";
    private static final String IP_SET_NAME = "name";
    private static final String IP_GROUP_NAME = "name";
    private static final String IP_VERSION = "ipVersion";
    private static final String IP_ADDRESS_INFO = "ipAddressInfo";
    private static final String IP_SET_IDS = "ipSetIds";
    private static final String IP_SET_ID = "ipSetId";
    private static final String IP_GROUP_ID = "ipGroupId";
    private static final String BIND_IP_SET = "bindIpSet";
    private static final String UN_BIND_IP_SET = "unbindIpSet";
    private static final HttpResponseHandler[] CONN_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public IpCollectionClient() {
        this(new IpCollectionClientConfiguration());
    }

    public IpCollectionClient(IpCollectionClientConfiguration clientConfiguration) {
        super(clientConfiguration, CONN_HANDLERS);
    }

    public CreateIpAddressSetResponse createIpAddressSet(CreateIpAddressSetRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat("name"));
        Validate.checkStringNotEmpty(request.getIpVersion(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_VERSION));
        Validate.checkListNotEmpty(request.getIpAddressInfo(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_ADDRESS_INFO));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, IP_SET_URL_PREFIX);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateIpAddressSetResponse.class);
    }

    public void addIpAddressToIpSet(AddIpAddressToIpSetRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getIpSetId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_SET_ID));
        Validate.checkListNotEmpty(request.getIpAddressInfo(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_ADDRESS_INFO));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, IP_SET_URL_PREFIX, request.getIpSetId(), IP_ADDRESS);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void removeIpAddressFromIpSet(RemoveIpAddressFromIpSetRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getIpSetId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_SET_ID));
        Validate.checkListNotEmpty(request.getIpAddressInfo(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_ADDRESS_INFO));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, IP_SET_URL_PREFIX, request.getIpSetId(), DELETE_IP_ADDRESS);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateIpSet(UpdateIpSetRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getIpSetId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_SET_ID));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, IP_SET_URL_PREFIX, request.getIpSetId());
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(IpCollectionAction.modifyAttribute.name(), null);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteIpSet(DeleteIpSetRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getIpSetId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_SET_ID));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, IP_SET_URL_PREFIX, request.getIpSetId());
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteIpSet(String ipSetId) {
        DeleteIpSetRequest request = new DeleteIpSetRequest();
        request.setIpSetId(ipSetId);
        this.deleteIpSet(request);
    }

    public QueryIpSetListResponse queryIpSetList(QueryIpSetListRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, IP_SET_URL_PREFIX, null);
        if (!Strings.isNullOrEmpty((String)request.getIpVersion())) {
            internalRequest.addParameter(IP_VERSION, request.getIpVersion());
        }
        if (!Strings.isNullOrEmpty((String)request.getMarker())) {
            internalRequest.addParameter(MARKER, request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getMaxKeys()));
        } else {
            internalRequest.addParameter(MAX_KEYS, QUERY_MAX_KEYS_VALUE);
        }
        return this.invokeHttpClient(internalRequest, QueryIpSetListResponse.class);
    }

    public QueryIpSetDetailResponse queryIpSetDetail(QueryIpSetDetailRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getIpSetId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_SET_ID));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, IP_SET_URL_PREFIX, request.getIpSetId());
        return this.invokeHttpClient(internalRequest, QueryIpSetDetailResponse.class);
    }

    public QueryIpSetDetailResponse queryIpSetDetail(String ipSetId) {
        QueryIpSetDetailRequest request = new QueryIpSetDetailRequest();
        request.setIpSetId(ipSetId);
        return this.queryIpSetDetail(request);
    }

    public CreateIpAddressGroupResponse createIpAddressGroup(CreateIpAddressGroupRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat("name"));
        Validate.checkStringNotEmpty(request.getIpVersion(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_VERSION));
        Validate.checkListNotEmpty(request.getIpSetIds(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_SET_IDS));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, IP_GROUP_URL_PREFIX);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateIpAddressGroupResponse.class);
    }

    public void bindIpSet(BindIpSetRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getIpGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_GROUP_ID));
        Validate.checkListNotEmpty(request.getIpSetIds(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_SET_IDS));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, IP_GROUP_URL_PREFIX, request.getIpGroupId(), BIND_IP_SET);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void unBindIpSet(UnBindIpSetRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getIpGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_GROUP_ID));
        Validate.checkListNotEmpty(request.getIpSetIds(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_SET_IDS));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, IP_GROUP_URL_PREFIX, request.getIpGroupId(), UN_BIND_IP_SET);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateIpGroup(UpdateIpGroupRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getIpGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_GROUP_ID));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, IP_GROUP_URL_PREFIX, request.getIpGroupId());
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(IpCollectionAction.modifyAttribute.name(), null);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteIpGroup(DeleteIpGroupRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getIpGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_GROUP_ID));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, IP_GROUP_URL_PREFIX, request.getIpGroupId());
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteIpGroup(String ipGroupId) {
        DeleteIpGroupRequest request = new DeleteIpGroupRequest();
        request.setIpGroupId(ipGroupId);
        this.deleteIpGroup(request);
    }

    public QueryIpGroupListResponse queryIpGroupList(QueryIpGroupListRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, IP_GROUP_URL_PREFIX, null);
        if (!Strings.isNullOrEmpty((String)request.getIpVersion())) {
            internalRequest.addParameter(IP_VERSION, request.getIpVersion());
        }
        if (!Strings.isNullOrEmpty((String)request.getMarker())) {
            internalRequest.addParameter(MARKER, request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getMaxKeys()));
        } else {
            internalRequest.addParameter(MAX_KEYS, QUERY_MAX_KEYS_VALUE);
        }
        return this.invokeHttpClient(internalRequest, QueryIpGroupListResponse.class);
    }

    public QueryIpGroupDetailResponse queryIpGroupDetail(QueryIpGroupDetailRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getIpGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IP_GROUP_ID));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, IP_GROUP_URL_PREFIX, request.getIpGroupId());
        return this.invokeHttpClient(internalRequest, QueryIpGroupDetailResponse.class);
    }

    public QueryIpGroupDetailResponse queryIpGroupDetail(String ipGroupId) {
        QueryIpGroupDetailRequest request = new QueryIpGroupDetailRequest();
        request.setIpGroupId(ipGroupId);
        return this.queryIpGroupDetail(request);
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }
}

