/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestorage;

import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.internal.InternalRequest;
import com.baidubce.services.tablestorage.AbstractTableStorageBceClient;
import com.baidubce.services.tablestorage.TableStorageConstants;
import com.baidubce.services.tablestorage.model.AbstractTableStorageRequest;
import com.baidubce.services.tablestorage.model.BatchDeleteRowRequest;
import com.baidubce.services.tablestorage.model.BatchDeleteRowResponse;
import com.baidubce.services.tablestorage.model.BatchGetRowRequest;
import com.baidubce.services.tablestorage.model.BatchGetRowResponse;
import com.baidubce.services.tablestorage.model.BatchPutRowRequest;
import com.baidubce.services.tablestorage.model.BatchPutRowResponse;
import com.baidubce.services.tablestorage.model.CreateInstanceRequest;
import com.baidubce.services.tablestorage.model.CreateInstanceResponse;
import com.baidubce.services.tablestorage.model.CreateTableRequest;
import com.baidubce.services.tablestorage.model.CreateTableResponse;
import com.baidubce.services.tablestorage.model.DeleteRowRequest;
import com.baidubce.services.tablestorage.model.DeleteRowResponse;
import com.baidubce.services.tablestorage.model.DropInstanceRequest;
import com.baidubce.services.tablestorage.model.DropInstanceResponse;
import com.baidubce.services.tablestorage.model.DropTableRequest;
import com.baidubce.services.tablestorage.model.DropTableResponse;
import com.baidubce.services.tablestorage.model.GetRowRequest;
import com.baidubce.services.tablestorage.model.GetRowResponse;
import com.baidubce.services.tablestorage.model.ListInstanceRequest;
import com.baidubce.services.tablestorage.model.ListInstanceResponse;
import com.baidubce.services.tablestorage.model.ListKeyRangesRequest;
import com.baidubce.services.tablestorage.model.ListKeyRangesResponse;
import com.baidubce.services.tablestorage.model.ListTablesRequest;
import com.baidubce.services.tablestorage.model.ListTablesResponse;
import com.baidubce.services.tablestorage.model.PutRowRequest;
import com.baidubce.services.tablestorage.model.PutRowResponse;
import com.baidubce.services.tablestorage.model.ScanRequest;
import com.baidubce.services.tablestorage.model.ScanResponse;
import com.baidubce.services.tablestorage.model.ShowInstanceRequest;
import com.baidubce.services.tablestorage.model.ShowInstanceResponse;
import com.baidubce.services.tablestorage.model.ShowTableRequest;
import com.baidubce.services.tablestorage.model.ShowTableResponse;
import com.baidubce.services.tablestorage.model.ShowTableStateResponse;
import com.baidubce.services.tablestorage.model.TableState;
import com.baidubce.services.tablestorage.model.UpdateTableRequest;
import com.baidubce.services.tablestorage.model.UpdateTableResponse;
import com.google.common.base.Preconditions;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class TableStorageClient
extends AbstractTableStorageBceClient {
    private String instanceName;

    public TableStorageClient(BceClientConfiguration config, String instanceName) {
        super(config, true);
        this.instanceName = instanceName;
    }

    private void checkInstance(String instanceName) {
        if (StringUtils.isBlank((CharSequence)instanceName)) {
            throw new BceClientException("The InstanceName's value should not be blank");
        }
        if (!Pattern.matches("[_a-zA-Z][_a-zA-Z0-9]{0,254}", instanceName)) {
            throw new BceClientException("The InstanceName's value should match the pattern : [_a-zA-Z][_a-zA-Z0-9]{0,254}.");
        }
        String lowerInstanceName = instanceName.toLowerCase();
        for (String word : TableStorageConstants.INSTANCE_NAME_NOT_START_WITH_WORDS) {
            if (!lowerInstanceName.startsWith(word)) continue;
            throw new BceClientException("The InstanceName's value should not start with " + word + ".");
        }
        for (String word : TableStorageConstants.INSTANCE_NAME_NOT_CONTAIN_WORDS) {
            if (!lowerInstanceName.contains(word)) continue;
            throw new BceClientException("The InstanceName's value should not contain " + word + ".");
        }
    }

    private void checkInput(AbstractTableStorageRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"Request should not be null");
        if (request instanceof CreateInstanceRequest) {
            this.checkInstance(((CreateInstanceRequest)request).getInstanceName());
        } else if (request instanceof ShowInstanceRequest) {
            this.checkInstance(((ShowInstanceRequest)request).getInstanceName());
        } else if (request instanceof DropInstanceRequest) {
            this.checkInstance(((DropInstanceRequest)request).getInstanceName());
        } else if (!(request instanceof ListInstanceRequest)) {
            this.checkInstance(this.instanceName);
            if (request instanceof ListTablesRequest) {
                if (request.getTableName() != null && !request.getTableName().isEmpty()) {
                    throw new BceClientException("The TableName's value should be empty in ListTablesRequest.");
                }
            } else {
                if (StringUtils.isBlank((CharSequence)request.getTableName())) {
                    throw new BceClientException("The TableName's value should not be blank in " + request.getClass().getSimpleName() + ".");
                }
                if (!Pattern.matches("[_a-zA-Z][_a-zA-Z0-9]{0,254}", request.getTableName())) {
                    throw new BceClientException("The TableName's value should match the pattern : [_a-zA-Z][_a-zA-Z0-9]{0,254}.");
                }
            }
        }
    }

    public CreateInstanceResponse createInstance(CreateInstanceRequest request) {
        this.checkInput(request);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, "instance", request.getInstanceName());
        return this.invokeHttpClient(internalRequest, CreateInstanceResponse.class);
    }

    public ShowInstanceResponse showInstance(ShowInstanceRequest request) {
        this.checkInput(request);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, "instance", request.getInstanceName());
        return this.invokeHttpClient(internalRequest, ShowInstanceResponse.class);
    }

    public ListInstanceResponse listInstance(ListInstanceRequest request) {
        this.checkInput(request);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, "instances");
        return this.invokeHttpClient(internalRequest, ListInstanceResponse.class);
    }

    public DropInstanceResponse dropInstance(DropInstanceRequest request) {
        this.checkInput(request);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, "instance", request.getInstanceName());
        return this.invokeHttpClient(internalRequest, DropInstanceResponse.class);
    }

    public CreateTableResponse createTable(CreateTableRequest request) {
        this.checkInput(request);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, "instance", this.instanceName, "table", request.getTableName());
        this.fillInHeadAndBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CreateTableResponse.class);
    }

    public UpdateTableResponse updateTable(UpdateTableRequest request) {
        this.checkInput(request);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, "instance", this.instanceName, "table", request.getTableName());
        this.fillInHeadAndBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, UpdateTableResponse.class);
    }

    public DropTableResponse dropTable(DropTableRequest request) {
        this.checkInput(request);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, "instance", this.instanceName, "table", request.getTableName());
        return this.invokeHttpClient(internalRequest, DropTableResponse.class);
    }

    public ListTablesResponse listTables(ListTablesRequest request) {
        this.checkInput(request);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, "instance", this.instanceName, "tables");
        return this.invokeHttpClient(internalRequest, ListTablesResponse.class);
    }

    public TableState showTableState(String tableName) {
        ShowTableRequest request = new ShowTableRequest(tableName);
        this.checkInput(request);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, "instance", this.instanceName, "table", tableName);
        internalRequest.addParameter("onlyState", "");
        ShowTableStateResponse response = this.invokeHttpClient(internalRequest, ShowTableStateResponse.class);
        return response.getTableState();
    }

    public ShowTableResponse showTable(ShowTableRequest request) {
        this.checkInput(request);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, "instance", this.instanceName, "table", request.getTableName());
        return this.invokeHttpClient(internalRequest, ShowTableResponse.class);
    }

    public ListKeyRangesResponse listKeyRanges(ListKeyRangesRequest request) {
        this.checkInput(request);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, "instance", this.instanceName, "table", request.getTableName(), "slices");
        return this.invokeHttpClient(internalRequest, ListKeyRangesResponse.class);
    }

    public GetRowResponse getRow(GetRowRequest request) {
        this.checkInput(request);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, "instance", this.instanceName, "table", request.getTableName(), "row");
        internalRequest.addHeader("x-bce-bts-method", "GET");
        this.fillInHeadAndBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, GetRowResponse.class);
    }

    public PutRowResponse putRow(PutRowRequest request) {
        this.checkInput(request);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, "instance", this.instanceName, "table", request.getTableName(), "row");
        internalRequest.addHeader("x-bce-bts-method", "PUT");
        this.fillInHeadAndBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, PutRowResponse.class);
    }

    public DeleteRowResponse deleteRow(DeleteRowRequest request) {
        this.checkInput(request);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, "instance", this.instanceName, "table", request.getTableName(), "row");
        internalRequest.addHeader("x-bce-bts-method", "DELETE");
        this.fillInHeadAndBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, DeleteRowResponse.class);
    }

    public BatchGetRowResponse batchGetRow(BatchGetRowRequest request) {
        this.checkInput(request);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, "instance", this.instanceName, "table", request.getTableName(), "rows");
        internalRequest.addHeader("x-bce-bts-method", "GET");
        this.fillInHeadAndBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, BatchGetRowResponse.class);
    }

    public BatchPutRowResponse batchPutRow(BatchPutRowRequest request) {
        this.checkInput(request);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, "instance", this.instanceName, "table", request.getTableName(), "rows");
        internalRequest.addHeader("x-bce-bts-method", "PUT");
        this.fillInHeadAndBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, BatchPutRowResponse.class);
    }

    public BatchDeleteRowResponse batchDeleteRow(BatchDeleteRowRequest request) {
        this.checkInput(request);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, "instance", this.instanceName, "table", request.getTableName(), "rows");
        internalRequest.addHeader("x-bce-bts-method", "DELETE");
        this.fillInHeadAndBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, BatchDeleteRowResponse.class);
    }

    public ScanResponse scan(ScanRequest request) {
        this.checkInput(request);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, "instance", this.instanceName, "table", request.getTableName(), "rows");
        internalRequest.addHeader("x-bce-bts-method", "GET");
        this.fillInHeadAndBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, ScanResponse.class);
    }
}

