/*
 * Copyright (c) 2014 Baidu.com, Inc. All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.bcc.model.volume;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * The request for resizing specified volume.
 */
public class ResizeVolumeRequest extends AbstractBceRequest {
    /**
     * An ASCII string whose length is less than 64.
     *
     * The request will be idempotent if client token is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     *     BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;

    /**
     * The id of volume.
     */
    @JsonIgnore
    private String volumeId;

    /**
     * The new volume size in GB, available size is 0-5120 GB
     */
    private int newCdsSizeInGB;

    public String getClientToken() {
        return clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    /**
     * Configure optional client token for the request. The request will be idempotent if client token is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     *
     * @param clientToken An ASCII string whose length is less than 64.
     *                    See more detail at
     *                    <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     *                        BCE API doc</a>
     * @return ResizeVolumeRequest with specific clientToken
     */
    public ResizeVolumeRequest withClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    public String getVolumeId() {
        return volumeId;
    }

    public void setVolumeId(String volumeId) {
        this.volumeId = volumeId;
    }

    /**
     * Configure volumeId for the request.
     *
     * @param volumeId The id of volume which will be resize.
     * @return ResizeVolumeRequest with volumeId.
     */
    public ResizeVolumeRequest withVolumeId(String volumeId) {
        this.volumeId = volumeId;
        return this;
    }

    public int getNewCdsSizeInGB() {
        return newCdsSizeInGB;
    }

    public void setNewCdsSizeInGB(int newCdsSizeInGB) {
        this.newCdsSizeInGB = newCdsSizeInGB;
    }

    /**
     * Configure newCdsSizeInGB for the request.
     *
     * @param newCdsSizeInGB The new volume size in GB, available size is 0-5120 GB
     * @return ResizeVolumeRequest with newCdsSizeInGB.
     */
    public ResizeVolumeRequest withNewCdsSizeInGB(int newCdsSizeInGB) {
        this.newCdsSizeInGB = newCdsSizeInGB;
        return this;
    }

    /**
     * Configure request credential for the request.
     *
     * @param credentials a valid instance of BceCredentials.
     * @return ResizeVolumeRequest with credentials.
     */
    @Override
    public ResizeVolumeRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
