package com.baidubce.services.subnet.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * request model to modify subnet
 */
public class ModifySubnetAttributesRequest extends AbstractBceRequest {

    /**
     * An ASCII string whose length is less than 64.
     * <p/>
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     * BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;

    /**
     * The id of subnet modified.
     */
    private String subnetId;

    /**
     * The new name of subnet
     */
    private String name;

    /**
     * The new value description of subnet.
     */
    private String description;

    /**
     * Configure optional client token for the request. The request will be idempotent if client token is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     *
     * @param clientToken An ASCII string whose length is less than 64.
     *                    See more detail at
     *                    <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     *                    BCE API doc</a>
     * @return ModifySubnetAttributesRequest with specific clientToken
     */
    public ModifySubnetAttributesRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    /**
     * Configure subnet id for the request.
     *
     * @param subnetId the id of subnet
     * @return ModifySubnetAttributesRequest with subnetId
     */
    public ModifySubnetAttributesRequest withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    /**
     * Configure name for the request.
     *
     * @param name The new name of subnet
     * @return ModifySubnetAttributesRequest with specific name
     */
    public ModifySubnetAttributesRequest withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Configure description for the request.
     *
     * @param description the type of subnet
     * @return ModifySubnetAttributesRequest with description
     */
    public ModifySubnetAttributesRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getClientToken() {
        return clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getSubnetId() {
        return subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * Configure request credential for the request.
     *
     * @param credentials a valid instance of BceCredentials.
     * @return ModifyVpcAttributesRequest with credentials.
     */
    @Override
    public ModifySubnetAttributesRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
