package com.baidubce.services.tsdb.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;

import java.util.List;
import java.util.Map;

/**
 * Represent the request for deleting datapoints.
 */
public class DeleteDatapointsRequest extends AbstractBceRequest {

    private String databaseId;

    /**
     * Option.
     * Conflict with metricFieldsList.
     */
    private List<String> metrics;

    /**
     * Option.
     * Conflict with metrics.
     */
    private List<MetricFields> metricFieldsList;

    private Long start;

    private Long end;

    private Map<String, List<String>> tags;

    public String getDatabaseId() {
        return databaseId;
    }

    public void setDatabaseId(String databaseId) {
        this.databaseId = databaseId;
    }

    public List<String> getMetrics() {
        return metrics;
    }

    public void setMetrics(List<String> metrics) {
        this.metrics = metrics;
    }

    public List<MetricFields> getMetricFieldsList() {
        return metricFieldsList;
    }

    public void setMetricFieldsList(List<MetricFields> metricFieldsList) {
        this.metricFieldsList = metricFieldsList;
    }

    public Long getStart() {
        return start;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    public Long getEnd() {
        return end;
    }

    public void setEnd(Long end) {
        this.end = end;
    }

    public Map<String, List<String>> getTags() {
        return tags;
    }

    public void setTags(Map<String, List<String>> tags) {
        this.tags = tags;
    }

    @Override
    public DeleteDatapointsRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
