/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tsdb;

import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.BceCredentials;
import com.baidubce.auth.BceV1Signer;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.internal.InternalRequest;
import com.baidubce.services.tsdb.AbstractTsdbBceClient;
import com.baidubce.services.tsdb.model.Datapoint;
import com.baidubce.services.tsdb.model.GetFieldsRequest;
import com.baidubce.services.tsdb.model.GetFieldsResponse;
import com.baidubce.services.tsdb.model.GetMetricsRequest;
import com.baidubce.services.tsdb.model.GetMetricsResponse;
import com.baidubce.services.tsdb.model.GetRowsWithSqlRequest;
import com.baidubce.services.tsdb.model.GetRowsWithSqlResponse;
import com.baidubce.services.tsdb.model.GetTagsRequest;
import com.baidubce.services.tsdb.model.GetTagsResponse;
import com.baidubce.services.tsdb.model.Query;
import com.baidubce.services.tsdb.model.QueryDatapointsRequest;
import com.baidubce.services.tsdb.model.QueryDatapointsResponse;
import com.baidubce.services.tsdb.model.WriteDatapointsRequest;
import com.baidubce.services.tsdb.model.WriteDatapointsResponse;
import com.baidubce.util.JsonUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URL;
import java.util.List;

public class TsdbClient
extends AbstractTsdbBceClient {
    private static final String ENDPOINT_HOST = ".tsdb.iot.gz.baidubce.com";
    private static final String DATAPOINT = "datapoint";
    private static final String METRIC = "metric";
    private static final String TAG = "tag";
    private static final String FIELD = "field";
    private static final String QUERY = "query";
    private static final String ROW = "row";
    private static final String SQL = "sql";

    public TsdbClient(BceClientConfiguration config) {
        super(config, TSDB_HANDLERS);
    }

    public TsdbClient(BceClientConfiguration config, String database) {
        super(config.getEndpoint() == null ? config.withEndpoint(database + ENDPOINT_HOST) : config, TSDB_HANDLERS);
    }

    public WriteDatapointsResponse writeDatapoints(List<Datapoint> datapoints) {
        return this.writeDatapoints(new WriteDatapointsRequest().withDatapoints(datapoints));
    }

    public WriteDatapointsResponse writeDatapoints(WriteDatapointsRequest writeDatapointsRequest) {
        Preconditions.checkNotNull((Object)writeDatapointsRequest, (Object)"request should not be null.");
        return this.writeDatapoints(writeDatapointsRequest, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteDatapointsResponse writeDatapoints(WriteDatapointsRequest writeDatapointsRequest, boolean isGzip) {
        Preconditions.checkNotNull((Object)writeDatapointsRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(writeDatapointsRequest, HttpMethodName.POST, DATAPOINT);
        if (isGzip) {
            byte[] bytes = this.toGzipBytes(writeDatapointsRequest);
            this.fillInHeadAndBodyForGzip(internalRequest, bytes);
            WriteDatapointsResponse response = null;
            try {
                response = this.invokeHttpClient(internalRequest, WriteDatapointsResponse.class);
            }
            finally {
                try {
                    internalRequest.getContent().close();
                }
                catch (IOException e) {
                    throw new BceClientException("Close content stream failed.", e);
                }
            }
            return response;
        }
        this.fillInHeadAndBody(writeDatapointsRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, WriteDatapointsResponse.class);
    }

    public GetMetricsResponse getMetrics() {
        return this.getMetrics(new GetMetricsRequest());
    }

    public GetMetricsResponse getMetrics(GetMetricsRequest getMetricsRequest) {
        Preconditions.checkNotNull((Object)getMetricsRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(getMetricsRequest, HttpMethodName.GET, METRIC);
        return this.invokeHttpClient(internalRequest, GetMetricsResponse.class);
    }

    public GetTagsResponse getTags(String metric) {
        return this.getTags(new GetTagsRequest().withMetric(metric));
    }

    public GetTagsResponse getTags(GetTagsRequest getTagsRequest) {
        Preconditions.checkNotNull((Object)getTagsRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(getTagsRequest, HttpMethodName.GET, METRIC, getTagsRequest.getMetric(), TAG);
        return this.invokeHttpClient(internalRequest, GetTagsResponse.class);
    }

    public GetFieldsResponse getFields(String metric) {
        return this.getFields(new GetFieldsRequest().withMetric(metric));
    }

    public GetFieldsResponse getFields(GetFieldsRequest getFieldsRequest) {
        Preconditions.checkNotNull((Object)getFieldsRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(getFieldsRequest, HttpMethodName.GET, METRIC, getFieldsRequest.getMetric(), FIELD);
        return this.invokeHttpClient(internalRequest, GetFieldsResponse.class);
    }

    public QueryDatapointsResponse queryDatapoints(List<Query> queries) {
        return this.queryDatapoints(new QueryDatapointsRequest().withQueries(queries));
    }

    public QueryDatapointsResponse queryDatapoints(QueryDatapointsRequest queryDatapointsRequest) {
        Preconditions.checkNotNull((Object)queryDatapointsRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(queryDatapointsRequest, HttpMethodName.PUT, DATAPOINT);
        internalRequest.addParameter(QUERY, null);
        this.fillInHeadAndBody(queryDatapointsRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, QueryDatapointsResponse.class);
    }

    public GetRowsWithSqlResponse getRowsWithSql(String sql) {
        return this.getRowsWithSql(new GetRowsWithSqlRequest().withSql(sql));
    }

    public GetRowsWithSqlResponse getRowsWithSql(GetRowsWithSqlRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, ROW);
        internalRequest.addParameter(SQL, request.getSql());
        return this.invokeHttpClient(internalRequest, GetRowsWithSqlResponse.class);
    }

    public URL generatePresignedUrlForQueryDatapoints(QueryDatapointsRequest queryDatapointsRequest) {
        return this.generatePresignedUrlForQueryDatapoints(queryDatapointsRequest, 1800);
    }

    public URL generatePresignedUrlForQueryDatapoints(List<Query> queries) {
        return this.generatePresignedUrlForQueryDatapoints(queries, 1800);
    }

    public URL generatePresignedUrlForQueryDatapoints(List<Query> queries, int expirationInSeconds) {
        return this.generatePresignedUrlForQueryDatapoints(new QueryDatapointsRequest().withQueries(queries), expirationInSeconds);
    }

    public URL generatePresignedUrlForQueryDatapoints(QueryDatapointsRequest queryDatapointsRequest, int expirationInSeconds) {
        InternalRequest internalRequest = this.createRequest(queryDatapointsRequest, HttpMethodName.GET, DATAPOINT);
        internalRequest.addParameter(QUERY, JsonUtils.toJsonString(queryDatapointsRequest));
        BceCredentials credentials = queryDatapointsRequest.getRequestCredentials();
        if (credentials == null) {
            credentials = this.config.getCredentials();
        }
        SignOptions signOptions = new SignOptions();
        signOptions.setExpirationInSeconds(expirationInSeconds);
        BceV1Signer signer = new BceV1Signer();
        signer.sign(internalRequest, credentials, signOptions);
        return this.convertRequestToUrl(internalRequest);
    }
}

