/*
 * Copyright 2018 Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.dugo.alarm;

import java.util.List;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.dugo.AbstractRequest;

/**
 * alarm details request
 * Created by liuzhenxing01 on 2018/10/22.
 */
public class AlarmDetailsRequest extends AbstractRequest {

    @Override
    public Class responseType() {
        return AlarmDetailsResponse.class;
    }

    public static class AlarmDetailsResponse extends AbstractBceResponse {
        private String alarmId;
        private String name;
        private String des;
        private List<String> batchIds;
        private List<String> vehicleIds;
        private String status;
        private AlarmRule alarmRule;
        private AlarmPolicy alarmPolicy;

        public String getAlarmId() {
            return alarmId;
        }

        public void setAlarmId(String alarmId) {
            this.alarmId = alarmId;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDes() {
            return des;
        }

        public void setDes(String des) {
            this.des = des;
        }

        public List<String> getBatchIds() {
            return batchIds;
        }

        public void setBatchIds(List<String> batchIds) {
            this.batchIds = batchIds;
        }

        public List<String> getVehicleIds() {
            return vehicleIds;
        }

        public void setVehicleIds(List<String> vehicleIds) {
            this.vehicleIds = vehicleIds;
        }

        public String getStatus() {
            return status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public AlarmRule getAlarmRule() {
            return alarmRule;
        }

        public void setAlarmRule(AlarmRule alarmRule) {
            this.alarmRule = alarmRule;
        }

        public AlarmPolicy getAlarmPolicy() {
            return alarmPolicy;
        }

        public void setAlarmPolicy(AlarmPolicy alarmPolicy) {
            this.alarmPolicy = alarmPolicy;
        }
    }
}
