/*
 * Copyright 2018 Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.dugo.map;

import java.util.List;

import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.dugo.AbstractRequest;

/**
 * query the vehicle stay point request model
 * Created by liuzhenxing01 on 2018/10/22.
 */
public class StayPointRequest extends AbstractRequest {

    private String vehicleId;
    private Long startTime;
    private Long endTime;
    private Integer stayTime;
    private Integer stayRadius;
    private String processOption;
    private String coordTypeOutput;

    public String getVehicleId() {
        return vehicleId;
    }

    public void setVehicleId(String vehicleId) {
        this.vehicleId = vehicleId;
    }

    public Long getStartTime() {
        return startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public Integer getStayTime() {
        return stayTime;
    }

    public void setStayTime(Integer stayTime) {
        this.stayTime = stayTime;
    }

    public Integer getStayRadius() {
        return stayRadius;
    }

    public void setStayRadius(Integer stayRadius) {
        this.stayRadius = stayRadius;
    }

    public String getProcessOption() {
        return processOption;
    }

    public void setProcessOption(String processOption) {
        this.processOption = processOption;
    }

    public String getCoordTypeOutput() {
        return coordTypeOutput;
    }

    public void setCoordTypeOutput(String coordTypeOutput) {
        this.coordTypeOutput = coordTypeOutput;
    }

    @Override
    public Class responseType() {
        return StayPointResponse.class;
    }

    public static class StayPointResponse extends AbstractBceResponse {
        private Integer staypointNum;
        private List<Staypoint> staypoints;

        public Integer getStaypointNum() {
            return staypointNum;
        }

        public void setStaypointNum(Integer staypointNum) {
            this.staypointNum = staypointNum;
        }

        public List<Staypoint> getStaypoints() {
            return staypoints;
        }

        public void setStaypoints(List<Staypoint> staypoints) {
            this.staypoints = staypoints;
        }
    }

    public static class Staypoint {
        private Long startTime;
        private Long endTime;
        private Integer duration;
        private Point point;

        public Long getStartTime() {
            return startTime;
        }

        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public Long getEndTime() {
            return endTime;
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public Integer getDuration() {
            return duration;
        }

        public void setDuration(Integer duration) {
            this.duration = duration;
        }

        public Point getPoint() {
            return point;
        }

        public void setPoint(Point point) {
            this.point = point;
        }
    }

    public static class Point {
        private Double latitude;
        private Double longitude;
        private Double radius;
        private String coordType;

        public Double getLatitude() {
            return latitude;
        }

        public void setLatitude(Double latitude) {
            this.latitude = latitude;
        }

        public Double getLongitude() {
            return longitude;
        }

        public void setLongitude(Double longitude) {
            this.longitude = longitude;
        }

        public Double getRadius() {
            return radius;
        }

        public void setRadius(Double radius) {
            this.radius = radius;
        }

        public String getCoordType() {
            return coordType;
        }

        public void setCoordType(String coordType) {
            this.coordType = coordType;
        }
    }
}
