/*
 * Copyright 2018 Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.dugo.project;

import java.util.List;

import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.dugo.AbstractRequest;

/**
 * get batchs model
 * Created by liuzhenxing01 on 2018/10/24.
 */
public class GetBatchsRequest extends AbstractRequest {

    @Override
    public Class responseType() {
        return GetBatchsResponse.class;
    }

    public static class GetBatchsResponse extends AbstractBceResponse {
        private Meta meta;
        private List<BatchInfoVo> data;

        public Meta getMeta() {
            return meta;
        }

        public void setMeta(Meta meta) {
            this.meta = meta;
        }

        public List<BatchInfoVo> getData() {
            return data;
        }

        public void setData(List<BatchInfoVo> data) {
            this.data = data;
        }
    }

    public static class Meta {
        private long total;
        private List<String> address;

        public long getTotal() {
            return total;
        }

        public void setTotal(long total) {
            this.total = total;
        }

        public List<String> getAddress() {
            return address;
        }

        public void setAddress(List<String> address) {
            this.address = address;
        }
    }
}
