/*
 * Copyright 2018 Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.dugo.shadow;

import java.util.List;

import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.dugo.AbstractRequest;
import com.fasterxml.jackson.databind.JsonNode;

/**
 * multiple shadow request model
 * Created by liuzhenxing01 on 2018/10/18.
 */
public class MultipleShadowRequest extends AbstractRequest {

    private List<String> vehicleIds;
    private List<String> fields;

    public List<String> getVehicleIds() {
        return vehicleIds;
    }

    public void setVehicleIds(List<String> vehicleIds) {
        this.vehicleIds = vehicleIds;
    }

    public List<String> getFields() {
        return fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    @Override
    public Class responseType() {
        return MultipleShadowResponse.class;
    }

    public static class MultipleShadowResponse extends AbstractBceResponse {
        private List<JsonNode> data;

        public List<JsonNode> getData() {
            return data;
        }

        public void setData(List<JsonNode> data) {
            this.data = data;
        }
    }
}