/*
 * Copyright 2018 Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.dugo.shadow;

import java.util.List;
import java.util.Map;

import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.dugo.AbstractRequest;
import com.fasterxml.jackson.databind.JsonNode;

/**
 * filter shadow reqeust
 * Created by liuzhenxing01 on 2018/10/22.
 */
public class ShadowFilterRequest extends AbstractRequest {
    private int pageNo;
    private int pageSize;
    private String projectId;
    private Map<String, String> tags;
    private List<String> fields;

    public int getPageNo() {
        return pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public Map<String, String> getTags() {
        return tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public List<String> getFields() {
        return fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    @Override
    public Class responseType() {
        return ShadowFilterResponse.class;
    }

    public static class ShadowFilterResponse extends AbstractBceResponse {
        private long amount;
        private int pageNo;
        private int pageSize;
        private List<JsonNode> data;

        public long getAmount() {
            return amount;
        }

        public void setAmount(long amount) {
            this.amount = amount;
        }

        public int getPageNo() {
            return pageNo;
        }

        public void setPageNo(int pageNo) {
            this.pageNo = pageNo;
        }

        public int getPageSize() {
            return pageSize;
        }

        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
        }

        public List<JsonNode> getData() {
            return data;
        }

        public void setData(List<JsonNode> data) {
            this.data = data;
        }
    }
}
