/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.dumap;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.dumap.handler.DuMapResponseHandler;
import com.baidubce.services.dumap.model.BaseDuMapResponse;
import com.baidubce.util.DateUtils;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseDuMapClient
extends AbstractBceClient {
    private static final Logger log = LoggerFactory.getLogger(BaseDuMapClient.class);
    private static final int DEFAULT_SOCKET_TIMEOUT = 10000;
    private static final String ENDPOINT = "http://lbs.baidubce.com";
    private static final String CONTENT_TYPE = "application/json;charset=utf-8";
    private static final String ACCEPT_TYPE = "application/json";
    private static final String APP_ID = "x-app-id";
    private static final String ACCEPT = "Accept";
    private static final String[] HEADERS_TO_SIGN = new String[]{"Host", "x-bce-date"};
    private static HttpResponseHandler[] dumapHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new DuMapResponseHandler()};

    public BaseDuMapClient() {
        this(new BceClientConfiguration());
    }

    public BaseDuMapClient(BceClientConfiguration config) {
        super(config.getEndpoint() == null ? config.withEndpoint(ENDPOINT) : config, dumapHandlers);
    }

    public BaseDuMapClient(String accessKey, String secretKey) {
        this(new BceClientConfiguration().withSocketTimeoutInMillis(10000).withCredentials(new DefaultBceCredentials(accessKey, secretKey)).withEndpoint(ENDPOINT));
    }

    protected BaseDuMapResponse callLbs(String uri, String appId, Object requestParams) {
        InternalRequest internalRequest = this.createRequest(null, HttpMethodName.GET, uri);
        internalRequest.addHeader(APP_ID, appId);
        internalRequest.addHeader(ACCEPT, ACCEPT_TYPE);
        this.fillParams(internalRequest, requestParams);
        log.debug("internal request: {}", (Object)JsonUtils.toJsonString(internalRequest));
        return this.invokeHttpClient(internalRequest, BaseDuMapResponse.class);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest internalRequest = new InternalRequest(httpMethod, uri);
        internalRequest.addHeader("x-bce-date", DateUtils.formatAlternateIso8601Date(new Date()));
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        internalRequest.setSignOptions(signOptions);
        internalRequest.setCredentials(this.config.getCredentials());
        if (httpMethod == HttpMethodName.POST || httpMethod == HttpMethodName.PUT) {
            this.fillInHeadAndBody(bceRequest, internalRequest);
        }
        return internalRequest;
    }

    private void fillInHeadAndBody(AbstractBceRequest bceRequest, InternalRequest request) {
        byte[] content = this.toJson(bceRequest);
        request.addHeader("Content-Length", Integer.toString(content.length));
        request.addHeader("Content-Type", CONTENT_TYPE);
        request.setContent(RestartableInputStream.wrap(content));
    }

    private byte[] toJson(AbstractBceRequest bceRequest) {
        String jsonStr = JsonUtils.toJsonString(bceRequest);
        try {
            return jsonStr.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
    }

    private void fillParams(InternalRequest request, Object obj) {
        Field[] fields;
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                if (field.get(obj) == null || "".equals(field.get(obj).toString())) continue;
                BaseDuMapClient.safeAddQueryParam(request, this.underscoreName(field.getName()), field.get(obj).toString());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    private static void safeAddQueryParam(InternalRequest request, String key, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            request.addParameter(key, value);
        }
    }

    private String underscoreName(String name) {
        StringBuilder result = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)name)) {
            return "";
        }
        result.append(name.substring(0, 1).toLowerCase());
        for (int i = 1; i < name.length(); ++i) {
            String s = name.substring(i, i + 1);
            if (s.equals(s.toUpperCase()) && !Character.isDigit(s.charAt(0))) {
                result.append("_");
            }
            result.append(s.toLowerCase());
        }
        return result.toString();
    }
}

