/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iotviz;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.iotviz.model.CreateTokenRequest;
import com.baidubce.services.iotviz.model.CreateTokenResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class IotVizClient
extends AbstractBceClient {
    private static final String ENDPOINT_HOST = "viz.baidubce.com";
    private static final String VERSION = "v2";
    private static final String[] HEADERS_TO_SIGN = new String[]{"Host", "x-bce-date"};
    private static final String TOKEN = "tokens";
    private static final HttpResponseHandler[] IOTVIZ_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public IotVizClient(BceClientConfiguration config) {
        super(config.getEndpoint() == null ? config.withEndpoint(ENDPOINT_HOST) : config, IOTVIZ_HANDLERS);
    }

    public String createToken(int ttl) {
        Preconditions.checkArgument((ttl > 0 ? 1 : 0) != 0);
        CreateTokenRequest request = new CreateTokenRequest();
        request.setTtl(ttl);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, null, TOKEN);
        CreateTokenResponse response = this.invokeHttpClient(internalRequest, CreateTokenResponse.class);
        return response.getToken();
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, SignOptions signOptions, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        if (signOptions == null) {
            signOptions = SignOptions.DEFAULT;
            signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        }
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        if (httpMethod == HttpMethodName.POST || httpMethod == HttpMethodName.PUT) {
            this.fillInHeaderAndBody(bceRequest, request);
        }
        return request;
    }

    private void fillInHeaderAndBody(AbstractBceRequest bceRequest, InternalRequest request) {
        byte[] bytes = this.toJson(bceRequest);
        request.addHeader("Content-Length", Integer.toString(bytes.length));
        request.addHeader("Content-Type", "application/json; charset=utf-8");
        request.setContent(RestartableInputStream.wrap(bytes));
    }

    private byte[] toJson(AbstractBceRequest bceRequest) {
        String jsonStr = JsonUtils.toJsonString(bceRequest);
        try {
            return jsonStr.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
    }
}

