/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.moladb.model.transform;

import com.baidubce.BceClientException;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.moladb.model.ListInstancesResponse;
import com.baidubce.services.moladb.model.transform.Unmarshaller;
import com.baidubce.services.moladb.model.transform.Unmarshallers;
import com.baidubce.util.JsonUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class ListInstancesResponseUnmarshaller
implements Unmarshaller<ListInstancesResponse, InputStream> {
    private ListInstancesResponse result;

    public ListInstancesResponseUnmarshaller(AbstractBceResponse response) {
        this.result = (ListInstancesResponse)response;
    }

    @Override
    public ListInstancesResponse unmarshall(InputStream inputStream) throws Exception {
        String streamContents = Unmarshallers.readStreamContents(inputStream);
        JsonNode root = JsonUtils.jsonNodeOf(streamContents);
        if (!root.isObject()) {
            throw new BceClientException("input json object:" + root.toString() + " is not an object");
        }
        JsonNode insObj = root.get("instanceNames");
        ArrayList<String> names = new ArrayList<String>();
        if (insObj != null) {
            Iterator instanceList = insObj.elements();
            while (instanceList.hasNext()) {
                JsonNode ins = (JsonNode)instanceList.next();
                names.add(ins.asText());
            }
        }
        this.result.setInstanceNames(names);
        return this.result;
    }
}

