/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.sms;

import com.baidubce.BceServiceException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.internal.InternalRequest;
import com.baidubce.services.sms.SmsClientConfiguration;
import com.baidubce.services.sms.SmsClientSupport;
import com.baidubce.services.sms.model.CreateTemplateRequest;
import com.baidubce.services.sms.model.CreateTemplateResponse;
import com.baidubce.services.sms.model.DeleteTemplateRequest;
import com.baidubce.services.sms.model.GetTemplateDetailRequest;
import com.baidubce.services.sms.model.GetTemplateDetailResponse;
import com.baidubce.services.sms.model.ListTemplateResponse;
import com.baidubce.services.sms.model.QueryMessageDetailRequest;
import com.baidubce.services.sms.model.QueryMessageDetailResponse;
import com.baidubce.services.sms.model.QueryQuotaResponse;
import com.baidubce.services.sms.model.SendMessageRequest;
import com.baidubce.services.sms.model.SendMessageResponse;
import com.baidubce.services.sms.model.SendMessageV2Request;
import com.baidubce.services.sms.model.SendMessageV2Response;
import com.baidubce.services.sms.model.SmsRequest;
import com.baidubce.services.sms.model.SmsResponse;
import com.baidubce.services.sms.model.StatReceiverRequest;
import com.baidubce.services.sms.model.StatReceiverResponse;
import com.baidubce.util.JsonUtils;
import com.google.common.base.Preconditions;

public class SmsClient
extends SmsClientSupport {
    public SmsClient() {
        this(new SmsClientConfiguration());
    }

    public SmsClient(SmsClientConfiguration config) {
        super(config, SMS_HANDLERS);
    }

    public SendMessageResponse sendMessage(SendMessageRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        this.assertStringNotNullOrEmpty(request.getTemplateId(), "string templateId of request should not be null or empty.");
        this.assertListNotNullOrEmpty(request.getReceiver(), "list receiver of request should not be null or empty.");
        for (String receiver : request.getReceiver()) {
            this.assertStringNotNullOrEmpty(receiver, "receiver should not be null or empty.");
        }
        InternalRequest internalRequest = this.createRequest("message", request, HttpMethodName.POST, new String[0]);
        internalRequest = this.fillRequestPayload(internalRequest, JsonUtils.toJsonString(request));
        return this.invokeHttpClient(internalRequest, SendMessageResponse.class);
    }

    public SendMessageV2Response sendMessage(SendMessageV2Request request) {
        Preconditions.checkNotNull((Object)request, (Object)"request is required.");
        this.assertStringNotNullOrEmpty(request.getInvokeId(), "invokeId is required.");
        this.assertStringNotNullOrEmpty(request.getPhoneNumber(), "phoneNumber is required.");
        this.assertStringNotNullOrEmpty(request.getTemplateCode(), "templateCode is required.");
        InternalRequest internalRequest = this.createGeneralRequest("bce/v2/message", request, HttpMethodName.POST, new String[0]);
        internalRequest = this.fillRequestPayload(internalRequest, JsonUtils.toJsonString(request));
        SendMessageV2Response response = null;
        try {
            response = this.invokeHttpClient(internalRequest, SendMessageV2Response.class);
        }
        catch (BceServiceException exception) {
            response = new SendMessageV2Response();
            response.setCode(exception.getErrorCode());
            response.setMessage(exception.getErrorMessage());
            response.setRequestId(exception.getRequestId());
        }
        return response;
    }

    public QueryMessageDetailResponse queryMessageDetail(QueryMessageDetailRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        this.assertStringNotNullOrEmpty(request.getMessageId(), "object messageId should not be null or empty.");
        InternalRequest internalRequest = this.createRequest("message", request, HttpMethodName.GET, request.getMessageId());
        return this.invokeHttpClient(internalRequest, QueryMessageDetailResponse.class);
    }

    public CreateTemplateResponse createTemplate(CreateTemplateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request is required.");
        this.assertStringNotNullOrEmpty(request.getName(), "template name is required.");
        this.assertStringNotNullOrEmpty(request.getContent(), "template content is required.");
        this.assertStringNotNullOrEmpty(request.getInvokeId(), "template invokeId is required.");
        InternalRequest internalRequest = this.createGeneralRequest("bce/v2/applyTemplate", request, HttpMethodName.POST, new String[0]);
        internalRequest = this.fillRequestPayload(internalRequest, JsonUtils.toJsonString(request));
        CreateTemplateResponse response = null;
        try {
            response = this.invokeHttpClient(internalRequest, CreateTemplateResponse.class);
        }
        catch (BceServiceException exception) {
            response = new CreateTemplateResponse();
            response.setCode(exception.getErrorCode());
            response.setMessage(exception.getErrorMessage());
            response.setRequestId(exception.getRequestId());
        }
        return response;
    }

    public void deleteTemplate(DeleteTemplateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        this.assertStringNotNullOrEmpty(request.getTemplateId(), "object templateId should not be null or empty.");
        InternalRequest internalRequest = this.createRequest("template", request, HttpMethodName.DELETE, request.getTemplateId());
        this.invokeHttpClient(internalRequest, SmsResponse.class);
    }

    public GetTemplateDetailResponse getTemplateDetail(GetTemplateDetailRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        this.assertStringNotNullOrEmpty(request.getTemplateId(), "object templateId should not be null or empty.");
        InternalRequest internalRequest = this.createRequest("template", request, HttpMethodName.GET, request.getTemplateId());
        return this.invokeHttpClient(internalRequest, GetTemplateDetailResponse.class);
    }

    public ListTemplateResponse listTemplate(SmsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        InternalRequest internalRequest = this.createRequest("template", request, HttpMethodName.GET, new String[0]);
        return this.invokeHttpClient(internalRequest, ListTemplateResponse.class);
    }

    public QueryQuotaResponse queryQuota(SmsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        InternalRequest internalRequest = this.createRequest("quota", request, HttpMethodName.GET, new String[0]);
        return this.invokeHttpClient(internalRequest, QueryQuotaResponse.class);
    }

    public StatReceiverResponse statReceiver(StatReceiverRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        this.assertStringNotNullOrEmpty(request.getPhoneNumber(), "object phoneNumber should not be null or empty.");
        InternalRequest internalRequest = this.createRequest("receiver", request, HttpMethodName.GET, request.getPhoneNumber());
        return this.invokeHttpClient(internalRequest, StatReceiverResponse.class);
    }
}

