/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.util;

import java.util.Date;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateUtils {
    private static final DateTimeFormatter iso8601DateFormat = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter alternateIso8601DateFormat = ISODateTimeFormat.dateTimeNoMillis().withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter rfc822DateFormat = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss 'GMT'").withLocale(Locale.US).withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter compressedIso8601DateFormat = ISODateTimeFormat.basicDateTimeNoMillis().withZone(DateTimeZone.UTC);

    public static Date parseIso8601Date(String dateString) {
        try {
            return iso8601DateFormat.parseDateTime(dateString).toDate();
        }
        catch (IllegalArgumentException e) {
            return alternateIso8601DateFormat.parseDateTime(dateString).toDate();
        }
    }

    public static String formatIso8601Date(Date date) {
        return iso8601DateFormat.print((ReadableInstant)new DateTime((Object)date));
    }

    public static Date parseAlternateIso8601Date(String dateString) {
        return alternateIso8601DateFormat.parseDateTime(dateString).toDate();
    }

    public static String formatAlternateIso8601Date(Date date) {
        return alternateIso8601DateFormat.print((ReadableInstant)new DateTime((Object)date));
    }

    public static Date parseRfc822Date(String dateString) {
        return rfc822DateFormat.parseDateTime(dateString).toDate();
    }

    public static String formatRfc822Date(Date date) {
        return rfc822DateFormat.print((ReadableInstant)new DateTime((Object)date));
    }

    public static Date parseCompressedIso8601Date(String dateString) {
        return compressedIso8601DateFormat.parseDateTime(dateString).toDate();
    }
}

