/*
 * Copyright 2018 Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.dugo.batch;

import java.util.List;
import java.util.Map;

import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.dugo.AbstractRequest;

/**
 * Vehicle Bind Batch Request
 * Created by liuzhenxing01 on 2018/10/31.
 */
public class VehicleBindBatchRequest extends AbstractRequest {

    private String batchId;
    private List<String> vehicleIds;
    private Map<String, String> iccids;

    public String getBatchId() {
        return batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public List<String> getVehicleIds() {
        return vehicleIds;
    }

    public void setVehicleIds(List<String> vehicleIds) {
        this.vehicleIds = vehicleIds;
    }

    public Map<String, String> getIccids() {
        return iccids;
    }

    public void setIccids(Map<String, String> iccids) {
        this.iccids = iccids;
    }

    @Override
    public Class responseType() {
        return VehicleBindBatchResponse.class;
    }

    public static class VehicleBindBatchResponse extends AbstractBceResponse {
    }
}
