/*
 * Copyright 2018 Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.dugo.cert;

import java.util.List;

import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.dugo.AbstractRequest;

/**
 * Query Bind Result Request
 * Created by liuzhenxing01 on 2018/10/25.
 */
public class QueryBindResultRequest extends AbstractRequest {

    @Override
    public Class responseType() {
        return QueryBindResultResponse.class;
    }

    public static class QueryBindResultResponse extends AbstractBceResponse {
        private List<BindResult> data;

        public List<BindResult> getData() {
            return data;
        }

        public void setData(List<BindResult> data) {
            this.data = data;
        }
    }

    public static class BindResult {
        private String id;
        private String startTime;
        private String endTime;
        private String status;
        private String download;

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getStartTime() {
            return startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndTime() {
            return endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public String getStatus() {
            return status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getDownload() {
            return download;
        }

        public void setDownload(String download) {
            this.download = download;
        }
    }
}
