/*
 * Copyright (C) 2016 Baidu, Inc. All Rights Reserved.
 */
package com.baidubce.services.eip.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * The request for resizing eip.
 */
public class ResizeEipRequest extends AbstractBceRequest {
    /**
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/EIP/API.html#.E9.80.9A.E7.94.A8.E8.AF.B4.E6.98.8E">
     *   BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;
    /**
     * eip address to be resized
     */
    @JsonIgnore
    private String eip;
    /**
     * specify new bandwidth in Mbps for eip
     */
    private Integer newBandwidthInMbps;

    public String getClientToken() {
        return clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getEip() {
        return eip;
    }

    public void setEip(String eip) {
        this.eip = eip;
    }

    public Integer getNewBandwidthInMbps() {
        return newBandwidthInMbps;
    }

    public void setNewBandwidthInMbps(Integer newBandwidthInMbps) {
        this.newBandwidthInMbps = newBandwidthInMbps;
    }

    public ResizeEipRequest withClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    public ResizeEipRequest withEip(String eip) {
        this.eip = eip;
        return this;
    }

    public ResizeEipRequest withNewBandwidthInMbps(Integer newBandwidthInMbps) {
        this.newBandwidthInMbps = newBandwidthInMbps;
        return this;
    }

    public ResizeEipRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
