package com.baidubce.services.vpc.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * The request for creating a newly vpc.
 */
public class CreateVpcRequest extends AbstractBceRequest {

    /**
     * An ASCII string whose length is less than 64.
     *
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     *     BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;

    /**
     * The name of vpc that will be created.
     */
    private String name;

    /**
     * The cidr of this vpc.
     */
    private String cidr;

    /**
     * The option param to describe the vpc
     */
    private String description;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCidr() {
        return cidr;
    }

    public void setCidr(String cidr) {
        this.cidr = cidr;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getClientToken() {
        return clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    /**
     * Configure request credential for the request.
     *
     * @param credentials a valid instance of BceCredentials.
     * @return CreateInstanceRequest with credentials.
     */
    public CreateVpcRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

    /**
     * Configure name for the request.
     *
     * @param name The name of vpc
     * @return CreateVpcRequest with specific name
     */
    public CreateVpcRequest withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Configure cidr for the request.
     *
     * @param  cidr the cidr of vpc
     * @return CreateVpcRequest with cidr
     */
    public CreateVpcRequest withCidr(String cidr) {
        this.cidr = cidr;
        return this;
    }

    /**
     * Configure description for the request.
     *
     * @param  description the type of vpc
     * @return CreateVpcRequest with description
     */
    public CreateVpcRequest withDescription(String description) {
        this.description = description;
        return this;
    }
}
