/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.dugo;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.services.dugo.AbstractRequest;
import com.baidubce.services.dugo.alarm.AlarmBatchRequest;
import com.baidubce.services.dugo.alarm.AlarmCreateRequest;
import com.baidubce.services.dugo.alarm.AlarmDetailsRequest;
import com.baidubce.services.dugo.alarm.AlarmRuleListRequest;
import com.baidubce.services.dugo.alarm.AlarmUpdateRequest;
import com.baidubce.services.dugo.batch.BindRequest;
import com.baidubce.services.dugo.batch.QueryInstancesByBatchRequest;
import com.baidubce.services.dugo.batch.VehicleBindBatchRequest;
import com.baidubce.services.dugo.cert.DownloadAuthInfoRequest;
import com.baidubce.services.dugo.cert.QueryBindResultRequest;
import com.baidubce.services.dugo.core.protocol.http.BceIotHttpClient;
import com.baidubce.services.dugo.dynamicdata.DynamicPropertyRequest;
import com.baidubce.services.dugo.map.DrivingBehaviorRequest;
import com.baidubce.services.dugo.map.GeoCodingRequest;
import com.baidubce.services.dugo.map.GetDistanceRequest;
import com.baidubce.services.dugo.map.GetLatestPointRequest;
import com.baidubce.services.dugo.map.GetTrackRequest;
import com.baidubce.services.dugo.map.ReverseGeoCodingRequest;
import com.baidubce.services.dugo.map.StayPointRequest;
import com.baidubce.services.dugo.project.GetBatchsRequest;
import com.baidubce.services.dugo.project.GetProjectByIdRequest;
import com.baidubce.services.dugo.project.GetProjectListRequest;
import com.baidubce.services.dugo.project.UpdateBatchDesRequest;
import com.baidubce.services.dugo.shadow.MultipleShadowRequest;
import com.baidubce.services.dugo.shadow.QueryVehicleStatusRequest;
import com.baidubce.services.dugo.shadow.ShadowFilterRequest;
import com.baidubce.services.dugo.shadow.SingleShadowRequest;
import com.baidubce.services.dugo.staticdata.StaticDataRequest;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class DuGoClient
extends AbstractBceClient {
    private static HttpResponseHandler[] duGoHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public DuGoClient(BceClientConfiguration config) {
        super(config, duGoHandlers);
    }

    public DynamicPropertyRequest.DynamicPropertyResponse uploadDynamicProperty(DynamicPropertyRequest request) {
        InternalRequest internalRequest = this.buildInternalRequest("/v1/data", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, DynamicPropertyRequest.DynamicPropertyResponse.class);
    }

    public StaticDataRequest.StaticDataResponse uploadStaticData(StaticDataRequest request) {
        this.isEmptyCheck(request.getVehicleId(), "vehicleId");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/static/upload", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, StaticDataRequest.StaticDataResponse.class);
    }

    public SingleShadowRequest.SingleShadowResponse querySingleShadow(SingleShadowRequest request) {
        this.isEmptyCheck(request.getVehicleId(), "vehicleId");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/shadow/query", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, SingleShadowRequest.SingleShadowResponse.class);
    }

    public MultipleShadowRequest.MultipleShadowResponse queryMultipleShadow(MultipleShadowRequest request) {
        if (request == null || request.getVehicleIds().size() == 0) {
            throw new IllegalArgumentException("vehicleIds should not be empty");
        }
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/shadow/batchquery", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, MultipleShadowRequest.MultipleShadowResponse.class);
    }

    public ShadowFilterRequest.ShadowFilterResponse queryShadowByTag(ShadowFilterRequest request) {
        this.isEmptyCheck(request.getProjectId(), "projectId");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/shadow/filterquery", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, ShadowFilterRequest.ShadowFilterResponse.class);
    }

    public GeoCodingRequest.GeoCodingResponse geoCoding(GeoCodingRequest request) {
        this.isEmptyCheck(request.getAddress(), "address");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/geocoder", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, GeoCodingRequest.GeoCodingResponse.class);
    }

    public ReverseGeoCodingRequest.ReverseGeoCodingResponse reverseGeoCoding(ReverseGeoCodingRequest request) {
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/reversegeocoder", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, ReverseGeoCodingRequest.ReverseGeoCodingResponse.class);
    }

    public GetLatestPointRequest.GetLatestPointResponse getLatestPoint(GetLatestPointRequest request) {
        this.isEmptyCheck(request.getVehicleId(), "vehicleId");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/track/getlatestpoint", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, GetLatestPointRequest.GetLatestPointResponse.class);
    }

    public GetDistanceRequest.GetDistanceResponse getDistance(GetDistanceRequest request) {
        this.isEmptyCheck(request.getVehicleId(), "vehicleId");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/track/getdistance", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, GetDistanceRequest.GetDistanceResponse.class);
    }

    public GetTrackRequest.GetTrackResponse getTrack(GetTrackRequest request) {
        this.isEmptyCheck(request.getVehicleId(), "vehicleId");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/track/gettrack", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, GetTrackRequest.GetTrackResponse.class);
    }

    public StayPointRequest.StayPointResponse getStayPoint(StayPointRequest request) {
        this.isEmptyCheck(request.getVehicleId(), "vehicleId");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/analysis/staypoint", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, StayPointRequest.StayPointResponse.class);
    }

    public DrivingBehaviorRequest.DrivingBehaviorResponse getDrivingBehavior(DrivingBehaviorRequest request) {
        this.isEmptyCheck(request.getVehicleId(), "vehicleId");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/analysis/drivingbehavior", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, DrivingBehaviorRequest.DrivingBehaviorResponse.class);
    }

    public BindRequest.BindResponse randomBindVehicleToProject(BindRequest request) {
        this.isEmptyCheck(request.getProjectId(), "projectId");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/vehicle/bind", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, BindRequest.BindResponse.class);
    }

    public BindRequest.BindResponse unbindVehicle(BindRequest request) {
        this.isEmptyCheck(request.getProjectId(), "projectId");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/vehicle/unbind", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, BindRequest.BindResponse.class);
    }

    public AlarmDetailsRequest.AlarmDetailsResponse getAlarmDetails(String projectId, String alarmId) {
        this.isEmptyCheck(projectId, "projectId");
        this.isEmptyCheck(alarmId, "alarmId");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("projectId", projectId);
        param.put("alarmId", alarmId);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/alarm", HttpMethodName.GET, null, param);
        return this.invokeHttpClient(internalRequest, AlarmDetailsRequest.AlarmDetailsResponse.class);
    }

    public AlarmRuleListRequest.AlarmRuleListResponse getAlarms(String projectId, int pageNum, int pageSize) {
        this.isEmptyCheck(projectId, "projectId");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("projectId", projectId);
        param.put("pageNum", String.valueOf(pageNum));
        param.put("pageSize", String.valueOf(pageSize));
        param.put("list", "");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/alarm", HttpMethodName.GET, null, param);
        return this.invokeHttpClient(internalRequest, AlarmRuleListRequest.AlarmRuleListResponse.class);
    }

    public AlarmBatchRequest.AlarmBatchResponse batchDelete(AlarmBatchRequest request, String projectId) {
        this.isEmptyCheck(projectId, "projectId");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("delete", "");
        param.put("projectId", projectId);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/alarm", HttpMethodName.POST, request, param);
        return this.invokeHttpClient(internalRequest, AlarmBatchRequest.AlarmBatchResponse.class);
    }

    public AlarmBatchRequest.AlarmBatchResponse batchShield(AlarmBatchRequest request, String projectId) {
        this.isEmptyCheck(projectId, "projectId");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("shield", "");
        param.put("projectId", projectId);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/alarm", HttpMethodName.POST, request, param);
        return this.invokeHttpClient(internalRequest, AlarmBatchRequest.AlarmBatchResponse.class);
    }

    public AlarmBatchRequest.AlarmBatchResponse batchRecover(AlarmBatchRequest request, String projectId) {
        this.isEmptyCheck(projectId, "projectId");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("recover", "");
        param.put("projectId", projectId);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/alarm", HttpMethodName.POST, request, param);
        return this.invokeHttpClient(internalRequest, AlarmBatchRequest.AlarmBatchResponse.class);
    }

    public AlarmCreateRequest.AlarmCreateResponse createAlarmRule(AlarmCreateRequest request, String projectId) {
        this.isEmptyCheck(projectId, "projectId");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("projectId", projectId);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/alarm", HttpMethodName.POST, request, param);
        return this.invokeHttpClient(internalRequest, AlarmCreateRequest.AlarmCreateResponse.class);
    }

    public AlarmUpdateRequest.AlarmUpdateResponse updateAlarm(AlarmUpdateRequest request, String projectId) {
        this.isEmptyCheck(projectId, "projectId");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("projectId", projectId);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/alarm", HttpMethodName.PUT, request, param);
        return this.invokeHttpClient(internalRequest, AlarmUpdateRequest.AlarmUpdateResponse.class);
    }

    public GetProjectListRequest.GetProjectListResponse getProjects() {
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/project", HttpMethodName.GET, null, null);
        return this.invokeHttpClient(internalRequest, GetProjectListRequest.GetProjectListResponse.class);
    }

    public GetBatchsRequest.GetBatchsResponse getBatchs(String projectId) {
        this.isEmptyCheck(projectId, "projectId");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/project/" + projectId + "/batches", HttpMethodName.GET, null, null);
        return this.invokeHttpClient(internalRequest, GetBatchsRequest.GetBatchsResponse.class);
    }

    public GetProjectByIdRequest.GetProjectByIdResponse getProjectById(String projectId) {
        this.isEmptyCheck(projectId, "projectId");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/project/" + projectId, HttpMethodName.GET, null, null);
        return this.invokeHttpClient(internalRequest, GetProjectByIdRequest.GetProjectByIdResponse.class);
    }

    public UpdateBatchDesRequest.UpdateBatchDesResponse updateBatchDes(UpdateBatchDesRequest request, String projectId, String batchId) {
        this.isEmptyCheck(projectId, "projectId");
        this.isEmptyCheck(batchId, "batchId");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/project/" + projectId + "/batch/" + batchId, HttpMethodName.PUT, request, null);
        return this.invokeHttpClient(internalRequest, UpdateBatchDesRequest.UpdateBatchDesResponse.class);
    }

    public QueryBindResultRequest.QueryBindResultResponse queryBindResult(String projectId) {
        this.isEmptyCheck(projectId, "projectId");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("projectId", projectId);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/mqtt/results", HttpMethodName.GET, null, param);
        return this.invokeHttpClient(internalRequest, QueryBindResultRequest.QueryBindResultResponse.class);
    }

    public DownloadAuthInfoRequest.DownloadAuthInfoResponse downloadAuthInfo(String downloadUrl) {
        this.isEmptyCheck(downloadUrl, "downloadUrl");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("downloadUrl", downloadUrl);
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/mqtt/download", HttpMethodName.GET, null, param);
        return this.invokeHttpClient(internalRequest, DownloadAuthInfoRequest.DownloadAuthInfoResponse.class);
    }

    public VehicleBindBatchRequest.VehicleBindBatchResponse bindVehiclesInBatch(VehicleBindBatchRequest request) {
        this.isEmptyCheck(request.getBatchId(), "batchId");
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/vehicle/bind/batch", HttpMethodName.POST, request, null);
        return this.invokeHttpClient(internalRequest, VehicleBindBatchRequest.VehicleBindBatchResponse.class);
    }

    public QueryInstancesByBatchRequest.QueryInstancesByBatchResponse queryInstanceByBatch(String batchId, int pageNum, int pageSize) {
        this.isEmptyCheck(batchId, "batchId");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("batchId", batchId);
        param.put("pageNum", String.valueOf(pageNum));
        param.put("pageSize", String.valueOf(pageSize));
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/vehicle/batch", HttpMethodName.GET, null, param);
        return this.invokeHttpClient(internalRequest, QueryInstancesByBatchRequest.QueryInstancesByBatchResponse.class);
    }

    public QueryVehicleStatusRequest.QueryVehicleStatusResponse queryVehicleOnlineStatus(QueryVehicleStatusRequest request) {
        InternalRequest internalRequest = this.buildInternalRequest("/v1/ivc/data/shadow/onlinequery", HttpMethodName.POST, request);
        return this.invokeHttpClient(internalRequest, QueryVehicleStatusRequest.QueryVehicleStatusResponse.class);
    }

    private InternalRequest buildInternalRequest(String path, HttpMethodName methodName, AbstractRequest request, Map<String, String> param) {
        BceIotHttpClient client = new BceIotHttpClient();
        client.withAuth(this.config.getCredentials().getAccessKeyId(), this.config.getCredentials().getSecretKey());
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path);
        client.withMethod(methodName, uri);
        if (methodName == HttpMethodName.POST || methodName == HttpMethodName.PUT) {
            client.withPayload(JsonUtils.toJsonString(request).getBytes());
        }
        if (param != null) {
            for (Map.Entry<String, String> entry : param.entrySet()) {
                client.addParams(entry.getKey(), entry.getValue());
            }
        }
        return client.getInternalRequest();
    }

    private InternalRequest buildInternalRequest(String path, HttpMethodName methodName, AbstractRequest request) {
        return this.buildInternalRequest(path, methodName, request, null);
    }

    private void isEmptyCheck(String keyValue, String keyName) {
        Validate.checkStringNotEmpty(keyValue, keyName + " should not be null");
    }
}

