/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.moladb;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientException;
import com.baidubce.BceServiceException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.moladb.MolaDbClientConfiguration;
import com.baidubce.services.moladb.MolaDbConstants;
import com.baidubce.services.moladb.MolaDbJsonResponseHandler;
import com.baidubce.services.moladb.model.AttributeValue;
import com.baidubce.services.moladb.model.BatchGetItemRequest;
import com.baidubce.services.moladb.model.BatchGetItemResponse;
import com.baidubce.services.moladb.model.BatchWriteItemRequest;
import com.baidubce.services.moladb.model.BatchWriteItemResponse;
import com.baidubce.services.moladb.model.CreateInstanceRequest;
import com.baidubce.services.moladb.model.CreateInstanceResponse;
import com.baidubce.services.moladb.model.CreateTableRequest;
import com.baidubce.services.moladb.model.CreateTableResponse;
import com.baidubce.services.moladb.model.DeleteInstanceRequest;
import com.baidubce.services.moladb.model.DeleteInstanceResponse;
import com.baidubce.services.moladb.model.DeleteItemRequest;
import com.baidubce.services.moladb.model.DeleteItemResponse;
import com.baidubce.services.moladb.model.DeleteTableRequest;
import com.baidubce.services.moladb.model.DeleteTableResponse;
import com.baidubce.services.moladb.model.GetInstanceRequest;
import com.baidubce.services.moladb.model.GetInstanceResponse;
import com.baidubce.services.moladb.model.GetItemRequest;
import com.baidubce.services.moladb.model.GetItemResponse;
import com.baidubce.services.moladb.model.GetTableRequest;
import com.baidubce.services.moladb.model.GetTableResponse;
import com.baidubce.services.moladb.model.Key;
import com.baidubce.services.moladb.model.ListInstancesRequest;
import com.baidubce.services.moladb.model.ListInstancesResponse;
import com.baidubce.services.moladb.model.ListTablesRequest;
import com.baidubce.services.moladb.model.ListTablesResponse;
import com.baidubce.services.moladb.model.PutItemRequest;
import com.baidubce.services.moladb.model.PutItemResponse;
import com.baidubce.services.moladb.model.QueryRequest;
import com.baidubce.services.moladb.model.QueryResponse;
import com.baidubce.services.moladb.model.UpdateItemRequest;
import com.baidubce.services.moladb.model.UpdateItemResponse;
import com.baidubce.services.moladb.model.UpdateTableRequest;
import com.baidubce.services.moladb.model.UpdateTableResponse;
import com.baidubce.util.HashUtils;
import com.baidubce.util.HttpUtils;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MolaDbClient
extends AbstractBceClient {
    private static final HttpResponseHandler[] MOLADB_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new MolaDbJsonResponseHandler()};
    private static Logger logger = LoggerFactory.getLogger(MolaDbClient.class);
    private static final String HEXES = "0123456789ABCDEF";
    private String defaultInstanceName;

    private static String getHex(byte[] raw) {
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    public MolaDbClient(MolaDbClientConfiguration conf) {
        super(conf, MOLADB_HANDLERS, false);
    }

    public void setDefaultInstanceName(String instanceName) {
        this.defaultInstanceName = instanceName;
    }

    public String getDefaultInstanceName() {
        return this.defaultInstanceName;
    }

    public CreateInstanceResponse createInstance(CreateInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest httpRequest = this.createRequest(HttpMethodName.POST, "instance");
        this.fillInHeadAndBody(request, httpRequest);
        CreateInstanceResponse ret = this.invokeHttpClient(httpRequest, CreateInstanceResponse.class);
        return ret;
    }

    public GetInstanceResponse getInstance(String instanceName) {
        Preconditions.checkNotNull((Object)instanceName, (Object)"request should not be null.");
        InternalRequest httpRequest = this.createRequest(HttpMethodName.GET, "instance", instanceName);
        GetInstanceResponse ret = this.invokeHttpClient(httpRequest, GetInstanceResponse.class);
        return ret;
    }

    public GetInstanceResponse getInstance(GetInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest httpRequest = this.createRequest(HttpMethodName.GET, "instance", request.getInstanceName());
        GetInstanceResponse ret = this.invokeHttpClient(httpRequest, GetInstanceResponse.class);
        return ret;
    }

    public DeleteInstanceResponse deleteInstance(DeleteInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest httpRequest = this.createRequest(HttpMethodName.DELETE, "instance", request.getInstanceName());
        DeleteInstanceResponse ret = this.invokeHttpClient(httpRequest, DeleteInstanceResponse.class);
        return ret;
    }

    public DeleteInstanceResponse deleteInstance(String instanceName) {
        Preconditions.checkNotNull((Object)instanceName, (Object)"request should not be null.");
        InternalRequest httpRequest = this.createRequest(HttpMethodName.DELETE, "instance", instanceName);
        DeleteInstanceResponse ret = this.invokeHttpClient(httpRequest, DeleteInstanceResponse.class);
        return ret;
    }

    public ListInstancesResponse listInstances() {
        ListInstancesRequest req = new ListInstancesRequest();
        return this.listInstances(req);
    }

    public ListInstancesResponse listInstances(ListInstancesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest httpRequest = this.createRequest(HttpMethodName.GET, "instance");
        ListInstancesResponse ret = this.invokeHttpClient(httpRequest, ListInstancesResponse.class);
        return ret;
    }

    public CreateTableResponse createTable(CreateTableRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest httpRequest = this.createRequestUnderInstance(HttpMethodName.POST, "table");
        this.fillInHeadAndBody(request, httpRequest);
        CreateTableResponse ret = this.invokeHttpClient(httpRequest, CreateTableResponse.class);
        return ret;
    }

    public DeleteTableResponse deleteTable(String tableName) {
        Preconditions.checkNotNull((Object)tableName, (Object)"request should not be null.");
        InternalRequest httpRequest = this.createRequestUnderInstance(HttpMethodName.DELETE, "table", tableName);
        DeleteTableResponse ret = this.invokeHttpClient(httpRequest, DeleteTableResponse.class);
        return ret;
    }

    public DeleteTableResponse deleteTable(DeleteTableRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest httpRequest = this.createRequestUnderInstance(HttpMethodName.DELETE, "table", request.getTableName());
        DeleteTableResponse ret = this.invokeHttpClient(httpRequest, DeleteTableResponse.class);
        return ret;
    }

    public UpdateTableResponse updateTable(UpdateTableRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest httpRequest = this.createRequestUnderInstance(HttpMethodName.PUT, "table", request.getTableName());
        this.fillInHeadAndBody(request, httpRequest);
        UpdateTableResponse ret = this.invokeHttpClient(httpRequest, UpdateTableResponse.class);
        return ret;
    }

    public GetTableResponse getTable(String tableName) {
        Preconditions.checkNotNull((Object)tableName, (Object)"request should not be null.");
        InternalRequest httpRequest = this.createRequestUnderInstance(HttpMethodName.GET, "table", tableName);
        GetTableResponse ret = this.invokeHttpClient(httpRequest, GetTableResponse.class);
        return ret;
    }

    public GetTableResponse getTable(GetTableRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest httpRequest = this.createRequestUnderInstance(HttpMethodName.GET, "table", request.getTableName());
        GetTableResponse ret = this.invokeHttpClient(httpRequest, GetTableResponse.class);
        return ret;
    }

    public ListTablesResponse listTables() {
        ListTablesRequest req = new ListTablesRequest();
        return this.listTables(req);
    }

    public ListTablesResponse listTables(ListTablesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest httpRequest = this.createRequestUnderInstance(HttpMethodName.GET, "table");
        ListTablesResponse ret = this.invokeHttpClient(httpRequest, ListTablesResponse.class);
        return ret;
    }

    public PutItemResponse putItem(PutItemRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest httpRequest = this.createRequestUnderInstance(HttpMethodName.PUT, "table", request.getTableName(), "item");
        this.fillInHeadAndBody(request, httpRequest);
        PutItemResponse ret = this.invokeHttpClient(httpRequest, PutItemResponse.class);
        return ret;
    }

    public GetItemResponse getItem(GetItemRequest request) throws BceClientException, BceServiceException {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        HttpMethodName method = HttpMethodName.GET;
        InternalRequest httpRequest = this.createRequestUnderInstance(method, "table", request.getTableName(), "item");
        this.buildGetItemRequest(httpRequest, request);
        GetItemResponse ret = this.invokeHttpClient(httpRequest, GetItemResponse.class);
        return ret;
    }

    public DeleteItemResponse deleteItem(DeleteItemRequest request) throws BceClientException, BceServiceException {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest httpRequest = this.createRequestUnderInstance(HttpMethodName.DELETE, "table", request.getTableName(), "item");
        this.putKeyInUrl(httpRequest, request.getKey());
        DeleteItemResponse ret = this.invokeHttpClient(httpRequest, DeleteItemResponse.class);
        return ret;
    }

    public UpdateItemResponse updateItem(UpdateItemRequest request) throws BceClientException, BceServiceException {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest httpRequest = this.createRequestUnderInstance(HttpMethodName.POST, "table", request.getTableName(), "item");
        this.fillInHeadAndBody(request, httpRequest);
        UpdateItemResponse ret = this.invokeHttpClient(httpRequest, UpdateItemResponse.class);
        return ret;
    }

    public BatchGetItemResponse batchGetItem(BatchGetItemRequest request) throws BceClientException, BceServiceException {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest httpRequest = this.createRequestUnderInstance(HttpMethodName.POST, "table");
        httpRequest.addParameter("batchGet", null);
        this.fillInHeadAndBody(request, httpRequest);
        BatchGetItemResponse ret = this.invokeHttpClient(httpRequest, BatchGetItemResponse.class);
        return ret;
    }

    public BatchWriteItemResponse batchWriteItem(BatchWriteItemRequest request) throws BceClientException, BceServiceException {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest httpRequest = this.createRequestUnderInstance(HttpMethodName.POST, "table");
        httpRequest.addParameter("batchWrite", null);
        this.fillInHeadAndBody(request, httpRequest);
        BatchWriteItemResponse ret = this.invokeHttpClient(httpRequest, BatchWriteItemResponse.class);
        return ret;
    }

    public QueryResponse query(QueryRequest request) throws BceClientException, BceServiceException {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest httpRequest = this.createRequestUnderInstance(HttpMethodName.POST, "table", request.getTableName(), "item");
        httpRequest.addParameter("query", null);
        this.fillInHeadAndBody(request, httpRequest);
        QueryResponse ret = this.invokeHttpClient(httpRequest, QueryResponse.class);
        return ret;
    }

    protected InternalRequest createRequest(HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> pathComponents = new ArrayList<String>();
        pathComponents.add("v1");
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                pathComponents.add(pathVariable);
            }
        }
        InternalRequest request = new InternalRequest(httpMethod, HttpUtils.appendUri(this.getEndpoint(), pathComponents.toArray(new String[pathComponents.size()])));
        request.setCredentials(this.config.getCredentials());
        request.addHeader("Content-Type", "application/json");
        return request;
    }

    protected InternalRequest createRequestUnderInstance(HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> pathComponents = new ArrayList<String>();
        pathComponents.add("v1");
        pathComponents.add("instance");
        if (this.defaultInstanceName == null) {
            throw new IllegalArgumentException("Instance name MUST be provided when accessing table");
        }
        pathComponents.add(this.defaultInstanceName);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                pathComponents.add(pathVariable);
            }
        }
        InternalRequest request = new InternalRequest(httpMethod, HttpUtils.appendUri(this.getEndpoint(), pathComponents.toArray(new String[pathComponents.size()])));
        request.setCredentials(this.config.getCredentials());
        request.addHeader("Content-Type", "application/json");
        return request;
    }

    protected void fillInHeadAndBody(AbstractBceRequest request, InternalRequest httpRequest) {
        String jsonStr = request.toString();
        try {
            byte[] content = jsonStr.getBytes(MolaDbConstants.DEFAULT_ENCODING);
            String md5 = "md5";
            try {
                md5 = MolaDbClient.getHex(HashUtils.computeMd5Hash(new ByteArrayInputStream(content)));
            }
            catch (Exception e) {
                logger.warn("Unable calc md5 of the request", (Throwable)e);
            }
            httpRequest.addHeader("Content-Length", Integer.toString(content.length));
            httpRequest.setContent(this.toRestartableInputStream(content));
            httpRequest.addHeader("Content-MD5", md5);
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("json string UnsupportedEncodingException:", e);
        }
    }

    private void putKeyInUrl(InternalRequest httpRequest, Key key) {
        for (Map.Entry<String, AttributeValue> entry : key.getAttributes().entrySet()) {
            httpRequest.addParameter(entry.getKey(), entry.getValue().getS());
        }
    }

    private void buildGetItemRequest(InternalRequest httpRequest, GetItemRequest req) {
        this.putKeyInUrl(httpRequest, req.getKey());
        if (req.isConsistentRead()) {
            httpRequest.addParameter("consistentRead", "true");
        }
        if (req.getAttributesToGet() != null && !req.getAttributesToGet().isEmpty()) {
            Iterator<String> iter = req.getAttributesToGet().iterator();
            String attrList = "";
            attrList = attrList + iter.next();
            while (iter.hasNext()) {
                attrList = attrList + "," + iter.next();
            }
            httpRequest.addParameter("attributesToGet", attrList);
        }
    }

    private RestartableInputStream toRestartableInputStream(byte[] input) {
        return RestartableInputStream.wrap(input);
    }
}

