/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bbc;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.BceCredentials;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.bbc.model.instance.BindBbcTagsRequest;
import com.baidubce.services.bbc.model.instance.CreateBbcImageRequest;
import com.baidubce.services.bbc.model.instance.CreateBbcImageResponse;
import com.baidubce.services.bbc.model.instance.CreateBbcInstanceRequest;
import com.baidubce.services.bbc.model.instance.CreateBbcInstanceResponse;
import com.baidubce.services.bbc.model.instance.GetBbcFlavorRaidResponse;
import com.baidubce.services.bbc.model.instance.GetBbcFlavorRequest;
import com.baidubce.services.bbc.model.instance.GetBbcFlavorResponse;
import com.baidubce.services.bbc.model.instance.GetBbcInstanceResponse;
import com.baidubce.services.bbc.model.instance.GetInstanceVpcRequest;
import com.baidubce.services.bbc.model.instance.GetInstanceVpcResponse;
import com.baidubce.services.bbc.model.instance.ListBbcFlavorResponse;
import com.baidubce.services.bbc.model.instance.ListBbcFlavorsRequest;
import com.baidubce.services.bbc.model.instance.ListBbcInstancesRequest;
import com.baidubce.services.bbc.model.instance.ListBbcInstancesResponse;
import com.baidubce.services.bbc.model.instance.ListOperationLogRequest;
import com.baidubce.services.bbc.model.instance.ListOperationLogResponse;
import com.baidubce.services.bbc.model.instance.RebuildBbcInstanceRequest;
import com.baidubce.services.bbc.model.instance.RenameBbcInstanceRequest;
import com.baidubce.services.bcc.BccClientConfiguration;
import com.baidubce.services.bcc.model.Billing;
import com.baidubce.services.bcc.model.TagModel;
import com.baidubce.services.bcc.model.image.DeleteImageRequest;
import com.baidubce.services.bcc.model.image.GetImageRequest;
import com.baidubce.services.bcc.model.image.GetImageResponse;
import com.baidubce.services.bcc.model.image.ListImagesRequest;
import com.baidubce.services.bcc.model.image.ListImagesResponse;
import com.baidubce.services.bcc.model.instance.GetInstanceRequest;
import com.baidubce.services.bcc.model.instance.InstanceAction;
import com.baidubce.services.bcc.model.instance.ModifyInstanceDescRequest;
import com.baidubce.services.bcc.model.instance.ModifyInstancePasswordRequest;
import com.baidubce.services.bcc.model.instance.RebootInstanceRequest;
import com.baidubce.services.bcc.model.instance.ReleaseInstanceRequest;
import com.baidubce.services.bcc.model.instance.StartInstanceRequest;
import com.baidubce.services.bcc.model.instance.StopInstanceRequest;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.StringFormatUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;

public class BbcClient
extends AbstractBceClient {
    private static final String VERSION = "v1";
    private static final String DELETE_VERSION = "v2";
    private static final String INSTANCE_PREFIX = "instance";
    private static final String FLAVOR_PREFIX = "flavor";
    private static final String FLAVOR_RAID_PREFIX = "flavorRaid";
    private static final String IMAGE_PREFIX = "image";
    private static final String OPERATION_LOG_PREFIX = "operationLog";
    private static final String TAG = "tag";
    private static final String VPC = "vpcSubnet";
    private static final String MARKER = "marker";
    private static final String MAX_KEYS = "maxKeys";
    private static final String INTERNAL_IP = "internalIp";
    private static final String IMAGE_TYPE = "imageType";
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";
    private static final String CLIENT_TOKEN = "clientToken";
    private static final String POST_PAID = "Postpaid";
    private static final String BIND = "bind";
    private static final String UNBIND = "unbind";
    private static final String REQUEST_NULL_ERROR_MESSAGE = "request should not be null.";
    private static final String INSTANCEID_MESSAGE_KEY = "instanceId";
    private static final String FLAVORID_MESSAGE_KEY = "flavorId";
    private static final String TAGKEY_MESSAGE_KEY = "tagKey";
    private static final String RAID_MESSAGE_KEY = "raid";
    private static final String CHANGETAGS_NULL_ERROR_MESSAGE = "request changeTags should not be null.";
    private static final String ADMINPASS_MESSAGE_KEY = "adminPass";
    private static final String BBC_ID_MESSAGE_KEY = "bbcId";
    private static final String NAME_MESSAGE_KEY = "name";
    private static final String DESC_MESSAGE_KEY = "desc";
    private static final String IMAGEID_MESSAGE_KEY = "imageId";
    private static final String IMAGENAME_MESSAGE_KEY = "imageName";
    private static final HttpResponseHandler[] bbc_handlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public BbcClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, bbc_handlers);
    }

    public BbcClient(BceClientConfiguration config, HttpResponseHandler[] responseHandlers, boolean isHttpAsyncPutEnabled) {
        super(config, responseHandlers, isHttpAsyncPutEnabled);
    }

    public BbcClient(BceClientConfiguration config, HttpResponseHandler[] responseHandlers) {
        super(config, responseHandlers);
    }

    public BbcClient() {
        this(new BccClientConfiguration());
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private InternalRequest createV2Request(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(DELETE_VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    public void bindInstanceTag(BindBbcTagsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        if (null != request.getChangeTags() && !request.getChangeTags().isEmpty()) {
            for (TagModel tag : request.getChangeTags()) {
                Validate.checkStringNotEmpty(tag.getTagKey(), StringFormatUtils.checkEmptyExceptionMessageFormat(TAGKEY_MESSAGE_KEY));
            }
        } else {
            throw new IllegalArgumentException(CHANGETAGS_NULL_ERROR_MESSAGE);
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId(), TAG);
        internalRequest.addParameter(BIND, null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void unBindInstanceTag(BindBbcTagsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        if (null != request.getChangeTags() && !request.getChangeTags().isEmpty()) {
            for (TagModel tag : request.getChangeTags()) {
                Validate.checkStringNotEmpty(tag.getTagKey(), StringFormatUtils.checkEmptyExceptionMessageFormat(TAGKEY_MESSAGE_KEY));
            }
        } else {
            throw new IllegalArgumentException(CHANGETAGS_NULL_ERROR_MESSAGE);
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId(), TAG);
        internalRequest.addParameter(UNBIND, null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void modifyBbcPassword(ModifyInstancePasswordRequest request) throws BceClientException {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getAdminPass(), StringFormatUtils.checkEmptyExceptionMessageFormat(ADMINPASS_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.changePass.name(), null);
        BceCredentials credentials = this.config.getCredentials();
        if (internalRequest.getCredentials() != null) {
            credentials = internalRequest.getCredentials();
        }
        try {
            request.setAdminPass(this.aes128WithFirst16Char(request.getAdminPass(), credentials.getSecretKey()));
        }
        catch (GeneralSecurityException e) {
            throw new BceClientException("Encryption procedure exception", e);
        }
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public GetInstanceVpcResponse getInstanceVpcsubnet(GetInstanceVpcRequest request) throws BceClientException {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        if (null != request.getBbcIds() && !request.getBbcIds().isEmpty()) {
            for (String bbcId : request.getBbcIds()) {
                Validate.checkStringNotEmpty(bbcId, StringFormatUtils.checkEmptyExceptionMessageFormat(BBC_ID_MESSAGE_KEY));
            }
        } else {
            throw new IllegalArgumentException(CHANGETAGS_NULL_ERROR_MESSAGE);
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VPC);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, GetInstanceVpcResponse.class);
    }

    public ListBbcInstancesResponse listBbcInstances(ListBbcInstancesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, INSTANCE_PREFIX);
        if (request.getMarker() != null) {
            internalRequest.addParameter(MARKER, request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getMaxKeys()));
        }
        if (!Strings.isNullOrEmpty((String)request.getInternalIp())) {
            internalRequest.addParameter(INTERNAL_IP, request.getInternalIp());
        }
        return this.invokeHttpClient(internalRequest, ListBbcInstancesResponse.class);
    }

    public GetBbcInstanceResponse getInstance(GetInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, INSTANCE_PREFIX, request.getInstanceId());
        return this.invokeHttpClient(internalRequest, GetBbcInstanceResponse.class);
    }

    public void startInstance(StartInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.start.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void stopInstance(StopInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.stop.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void rebootInstance(RebootInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.reboot.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void renameBbcInstance(RenameBbcInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat(NAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.rename.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void modifyInstanceDesc(ModifyInstanceDescRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getDesc(), StringFormatUtils.checkEmptyExceptionMessageFormat(DESC_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.updateDesc.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void rebuildBbcInstance(RebuildBbcInstanceRequest request) throws BceClientException {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getImageId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IMAGEID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getAdminPass(), StringFormatUtils.checkEmptyExceptionMessageFormat(ADMINPASS_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.rebuild.name(), null);
        BceCredentials credentials = this.config.getCredentials();
        if (internalRequest.getCredentials() != null) {
            credentials = internalRequest.getCredentials();
        }
        try {
            request.setAdminPass(this.aes128WithFirst16Char(request.getAdminPass(), credentials.getSecretKey()));
        }
        catch (GeneralSecurityException e) {
            throw new BceClientException("Encryption procedure exception", e);
        }
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void releaseBbcInstance(ReleaseInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createV2Request(request, HttpMethodName.DELETE, INSTANCE_PREFIX, request.getInstanceId());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListBbcFlavorResponse listBbcFlavors(ListBbcFlavorsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, FLAVOR_PREFIX);
        return this.invokeHttpClient(internalRequest, ListBbcFlavorResponse.class);
    }

    public GetBbcFlavorResponse getBbcFlavor(GetBbcFlavorRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getFlavorId(), StringFormatUtils.checkEmptyExceptionMessageFormat(FLAVORID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, FLAVOR_PREFIX, request.getFlavorId());
        return this.invokeHttpClient(internalRequest, GetBbcFlavorResponse.class);
    }

    public GetBbcFlavorRaidResponse getBbcFlavorRaid(GetBbcFlavorRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getFlavorId(), StringFormatUtils.checkEmptyExceptionMessageFormat(FLAVORID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, FLAVOR_RAID_PREFIX, request.getFlavorId());
        return this.invokeHttpClient(internalRequest, GetBbcFlavorRaidResponse.class);
    }

    public CreateBbcImageResponse createBbcImage(CreateBbcImageRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        Validate.checkStringNotEmpty(request.getImageName(), StringFormatUtils.checkEmptyExceptionMessageFormat(IMAGENAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, IMAGE_PREFIX);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBbcImageResponse.class);
    }

    public ListImagesResponse listImages(ListImagesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, IMAGE_PREFIX);
        if (!Strings.isNullOrEmpty((String)request.getMarker())) {
            internalRequest.addParameter(MARKER, request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getMaxKeys()));
        }
        if (!Strings.isNullOrEmpty((String)request.getImageType())) {
            internalRequest.addParameter(IMAGE_TYPE, request.getImageType());
        }
        return this.invokeHttpClient(internalRequest, ListImagesResponse.class);
    }

    public GetImageResponse getImage(GetImageRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getImageId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IMAGEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, IMAGE_PREFIX, request.getImageId());
        return this.invokeHttpClient(internalRequest, GetImageResponse.class);
    }

    public void deleteImage(DeleteImageRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getImageId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IMAGEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, IMAGE_PREFIX, request.getImageId());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListOperationLogResponse listBbcOperationLog(ListOperationLogRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, OPERATION_LOG_PREFIX);
        if (!Strings.isNullOrEmpty((String)request.getMarker())) {
            internalRequest.addParameter(MARKER, request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getMaxKeys()));
        }
        if (!Strings.isNullOrEmpty((String)request.getStartTime())) {
            internalRequest.addParameter(START_TIME, request.getStartTime());
        }
        if (!Strings.isNullOrEmpty((String)request.getEndTime())) {
            internalRequest.addParameter(END_TIME, request.getEndTime());
        }
        return this.invokeHttpClient(internalRequest, ListOperationLogResponse.class);
    }

    public CreateBbcInstanceResponse createInstance(CreateBbcInstanceRequest request) throws BceClientException {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (null == request.getBilling()) {
            request.setBilling(this.generateDefaultBilling());
        }
        if (null != request.getTags() && !request.getTags().isEmpty()) {
            for (TagModel tag : request.getTags()) {
                Validate.checkStringNotEmpty(tag.getTagKey(), StringFormatUtils.checkEmptyExceptionMessageFormat(TAGKEY_MESSAGE_KEY));
            }
        }
        Validate.checkStringNotEmpty(request.getImageId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IMAGEID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getFlavorId(), StringFormatUtils.checkEmptyExceptionMessageFormat(FLAVORID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getRaidId(), StringFormatUtils.checkEmptyExceptionMessageFormat(RAID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, INSTANCE_PREFIX);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        if (!Strings.isNullOrEmpty((String)request.getAdminPass())) {
            BceCredentials credentials = this.config.getCredentials();
            if (internalRequest.getCredentials() != null) {
                credentials = internalRequest.getCredentials();
            }
            try {
                request.setAdminPass(this.aes128WithFirst16Char(request.getAdminPass(), credentials.getSecretKey()));
            }
            catch (GeneralSecurityException e) {
                throw new BceClientException("Encryption procedure exception", e);
            }
        }
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBbcInstanceResponse.class);
    }

    private Billing generateDefaultBilling() {
        Billing billing = new Billing();
        billing.setPaymentTiming(POST_PAID);
        return billing;
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }

    private String aes128WithFirst16Char(String content, String privateKey) throws GeneralSecurityException {
        byte[] crypted = null;
        SecretKeySpec skey = new SecretKeySpec(privateKey.substring(0, 16).getBytes(), "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(1, skey);
        crypted = cipher.doFinal(content.getBytes());
        return new String(Hex.encodeHex((byte[])crypted));
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }
}

