/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.dumap;

import com.baidubce.BceClientConfiguration;
import com.baidubce.http.HttpMethodName;
import com.baidubce.services.dumap.BaseDuMapClient;
import com.baidubce.services.dumap.model.DirectionDrivingParam;
import com.baidubce.services.dumap.model.DirectionRidingParam;
import com.baidubce.services.dumap.model.DirectionTransitParam;
import com.baidubce.services.dumap.model.GeocoderParam;
import com.baidubce.services.dumap.model.GeoconvParam;
import com.baidubce.services.dumap.model.HardwareLocationRequest;
import com.baidubce.services.dumap.model.IPLocationParam;
import com.baidubce.services.dumap.model.PlaceDetailParam;
import com.baidubce.services.dumap.model.PlaceSearchByBoundsParam;
import com.baidubce.services.dumap.model.PlaceSearchByLocationParam;
import com.baidubce.services.dumap.model.PlaceSearchByRegionParam;
import com.baidubce.services.dumap.model.ReverseGeocoderParam;
import com.baidubce.util.Validate;
import org.apache.commons.lang3.StringUtils;

public class DuMapClient
extends BaseDuMapClient {
    private static final String DEFAULT_OUTPUT = "json";
    private static final int DEFAULT_RADIUS = 1000;
    private static final int DEFAULT_PAGE_INDEX = 1;
    private static final int DEFAULT_PAGE_SIZE = 10;
    private static final int DEFAULT_CONV_FROM = 1;
    private static final int DEFAULT_CONV_TO = 5;

    public DuMapClient() {
    }

    public DuMapClient(BceClientConfiguration configuration) {
        super(configuration);
    }

    public String placeQuery(String appId, PlaceSearchByBoundsParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkStringNotEmpty(param.getQuery(), "\u68c0\u7d22\u5173\u952e\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkStringNotEmpty(param.getBounds(), "\u68c0\u7d22\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isBlank((CharSequence)param.getOutput())) {
            param.setOutput(DEFAULT_OUTPUT);
        }
        return this.callDuMap("/place/v2/search", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String placeQuery(String appId, PlaceSearchByRegionParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkStringNotEmpty(param.getQuery(), "\u68c0\u7d22\u5173\u952e\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkStringNotEmpty(param.getRegion(), "\u68c0\u7d22\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isBlank((CharSequence)param.getOutput())) {
            param.setOutput(DEFAULT_OUTPUT);
        }
        return this.callDuMap("/place/v2/search", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String placeQuery(String appId, PlaceSearchByLocationParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkStringNotEmpty(param.getQuery(), "\u68c0\u7d22\u5173\u952e\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkStringNotEmpty(param.getLocation(), "\u68c0\u7d22\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isBlank((CharSequence)param.getOutput())) {
            param.setOutput(DEFAULT_OUTPUT);
        }
        return this.callDuMap("/place/v2/search", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String placeDetail(String appId, PlaceDetailParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkStringNotEmpty(param.getUid(), "poi\u7684uid\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getScope(), "\u68c0\u7d22\u7ed3\u679c\u8be6\u7ec6\u7a0b\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u53ef\u53d6\u503c1\u30012");
        if (StringUtils.isBlank((CharSequence)param.getOutput())) {
            param.setOutput(DEFAULT_OUTPUT);
        }
        return this.callDuMap("/place/v2/detail", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String geocoder(String appId, GeocoderParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkStringNotEmpty(param.getAddress(), "\u89e3\u6790\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isBlank((CharSequence)param.getOutput())) {
            param.setOutput(DEFAULT_OUTPUT);
        }
        return this.callDuMap("/geocoder/v2/", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String reverseGeocoder(String appId, ReverseGeocoderParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkStringNotEmpty(param.getLocation(), "\u89e3\u6790\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isBlank((CharSequence)param.getOutput())) {
            param.setOutput(DEFAULT_OUTPUT);
        }
        if (param.getRadius() == 0) {
            param.setRadius(1000);
        }
        return this.callDuMap("/geocoder/v2/", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String direction(String appId, DirectionTransitParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkStringNotEmpty(param.getOrigin(), "\u8d77\u70b9\u5750\u6807\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkStringNotEmpty(param.getDestination(), "\u7ec8\u70b9\u5750\u6807\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isBlank((CharSequence)param.getOutput())) {
            param.setOutput(DEFAULT_OUTPUT);
        }
        if (param.getPageSize() == 0) {
            param.setPageSize(10);
        }
        if (param.getPageIndex() == 0) {
            param.setPageIndex(1);
        }
        return this.callDuMap("/direction/v2/transit", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String direction(String appId, DirectionRidingParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkStringNotEmpty(param.getOrigin(), "\u8d77\u70b9\u5750\u6807\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkStringNotEmpty(param.getDestination(), "\u7ec8\u70b9\u5750\u6807\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isBlank((CharSequence)param.getOutput())) {
            param.setOutput(DEFAULT_OUTPUT);
        }
        return this.callDuMap("/direction/v2/transit", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String direction(String appId, DirectionDrivingParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkStringNotEmpty(param.getOrigin(), "\u8d77\u70b9\u5750\u6807\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkStringNotEmpty(param.getDestination(), "\u7ec8\u70b9\u5750\u6807\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isBlank((CharSequence)param.getOutput())) {
            param.setOutput(DEFAULT_OUTPUT);
        }
        return this.callDuMap("/direction/v2/transit", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String geoconv(String appId, GeoconvParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkStringNotEmpty(param.getCoords(), "\u6e90\u5750\u6807\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isBlank((CharSequence)param.getOutput())) {
            param.setOutput(DEFAULT_OUTPUT);
        }
        if (param.getFrom() == 0) {
            param.setFrom(1);
        }
        if (param.getTo() == 0) {
            param.setTo(5);
        }
        return this.callDuMap("/geoconv/v1/", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String locate(String appId, IPLocationParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap("/location/ip", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String locate(String appId, HardwareLocationRequest request) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getSrc(), "\u5382\u5546\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getProd(), "\u4ea7\u54c1\u7ebf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getVer(), "\u670d\u52a1\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap("/locapi/v2", appId, request, null, HttpMethodName.POST).getPayload();
    }
}

