/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.dumap;

import com.baidubce.BceClientConfiguration;
import com.baidubce.http.HttpMethodName;
import com.baidubce.services.dumap.BaseDuMapClient;
import com.baidubce.services.dumap.trace.analysis.DrivingBehaviorAnalysisParam;
import com.baidubce.services.dumap.trace.analysis.StayPointAnalysisParam;
import com.baidubce.services.dumap.trace.entity.AddEntityRequest;
import com.baidubce.services.dumap.trace.entity.DeleteEntityRequest;
import com.baidubce.services.dumap.trace.entity.ListEntityParam;
import com.baidubce.services.dumap.trace.entity.UpdateEntityRequest;
import com.baidubce.services.dumap.trace.export.CreateJobRequest;
import com.baidubce.services.dumap.trace.export.DeleteJobRequest;
import com.baidubce.services.dumap.trace.export.GetJobParam;
import com.baidubce.services.dumap.trace.fence.AddMonitoredPersonRequest;
import com.baidubce.services.dumap.trace.fence.BatchHistoryAlarmParam;
import com.baidubce.services.dumap.trace.fence.CancelCallbackUrlRequest;
import com.baidubce.services.dumap.trace.fence.CreateCircleFenceRequest;
import com.baidubce.services.dumap.trace.fence.CreateDistrictFenceRequest;
import com.baidubce.services.dumap.trace.fence.CreatePolygonFenceRequest;
import com.baidubce.services.dumap.trace.fence.CreatePolylineFenceRequest;
import com.baidubce.services.dumap.trace.fence.DeleteFenceRequest;
import com.baidubce.services.dumap.trace.fence.DeleteMonitoredPersonRequest;
import com.baidubce.services.dumap.trace.fence.HistoryAlarmParam;
import com.baidubce.services.dumap.trace.fence.ListFenceParam;
import com.baidubce.services.dumap.trace.fence.ListMonitoredPersonParam;
import com.baidubce.services.dumap.trace.fence.QueryCallbackUrlParam;
import com.baidubce.services.dumap.trace.fence.QueryStatusByLocationParam;
import com.baidubce.services.dumap.trace.fence.QueryStatusParam;
import com.baidubce.services.dumap.trace.fence.SetCallbackUrlRequest;
import com.baidubce.services.dumap.trace.fence.UpdateCircleFenceRequest;
import com.baidubce.services.dumap.trace.fence.UpdateDistrictFenceRequest;
import com.baidubce.services.dumap.trace.fence.UpdatePolygonFenceRequest;
import com.baidubce.services.dumap.trace.fence.UpdatePolylineFenceRequest;
import com.baidubce.services.dumap.trace.point.AddPointRequest;
import com.baidubce.services.dumap.trace.point.AddPointsRequest;
import com.baidubce.services.dumap.trace.search.AroundSearchParam;
import com.baidubce.services.dumap.trace.search.BoundSearchParam;
import com.baidubce.services.dumap.trace.search.DistrictSearchParam;
import com.baidubce.services.dumap.trace.search.KeywordSearchParam;
import com.baidubce.services.dumap.trace.search.PolygonSearchParam;
import com.baidubce.services.dumap.trace.track.GetDistanceParam;
import com.baidubce.services.dumap.trace.track.GetLatestPointParam;
import com.baidubce.services.dumap.trace.track.GetTrackParam;
import com.baidubce.util.Validate;

public class DuMapTraceClient
extends BaseDuMapClient {
    private static final String DEFAULT_URI_PREFIX = "/api";
    private String uriPrefix = "/api";

    public DuMapTraceClient() {
    }

    public DuMapTraceClient(BceClientConfiguration configuration) {
        super(configuration);
    }

    public DuMapTraceClient withUriPrefix(String uriPrefix) {
        this.uriPrefix = uriPrefix;
        return this;
    }

    public String addEntity(String appId, AddEntityRequest request) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkStringNotEmpty(request.getEntityName(), "entity\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/entity/add", appId, request, null, HttpMethodName.POST).getPayload();
    }

    public String updateEntity(String appId, UpdateEntityRequest request) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkStringNotEmpty(request.getEntityName(), "entity\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/entity/update", appId, request, null, HttpMethodName.POST).getPayload();
    }

    public String deleteEntity(String appId, DeleteEntityRequest request) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkStringNotEmpty(request.getEntityName(), "entity\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/entity/delete", appId, request, null, HttpMethodName.POST).getPayload();
    }

    public String listEntity(String appId, ListEntityParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/entity/list", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String addPoint(String appId, AddPointRequest request) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkStringNotEmpty(request.getEntityName(), "entity\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getLatitude(), "\u5750\u6807\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getLongitude(), "\u5750\u6807\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getLocTime(), "\u5b9a\u4f4d\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getCoordTypeInput(), "\u5750\u6807\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/track/addpoint", appId, request, null, HttpMethodName.POST).getPayload();
    }

    public String addPoint(String appId, AddPointsRequest request) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkStringNotEmpty(request.getPointList(), "\u8f68\u8ff9\u70b9\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/track/addpoints", appId, request, null, HttpMethodName.POST).getPayload();
    }

    public String search(String appId, KeywordSearchParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getQuery(), "\u641c\u7d22\u5173\u952e\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/entity/search", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String search(String appId, BoundSearchParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getBounds(), "\u77e9\u5f62\u533a\u57df\u5750\u6807\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/entity/boundsearch", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String search(String appId, AroundSearchParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getCenter(), "\u4e2d\u5fc3\u70b9\u5750\u6807\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getRadius(), "\u534a\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/entity/aroundsearch", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String search(String appId, PolygonSearchParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getVertexes(), "\u8fb9\u754c\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/entity/polygonsearch", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String search(String appId, DistrictSearchParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getKeyword(), "\u884c\u653f\u533a\u5212\u5173\u952e\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/entity/districtsearch", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String track(String appId, GetLatestPointParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getEntityName(), "entity\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/track/getlatestpoint", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String track(String appId, GetDistanceParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getEntityName(), "entity\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getStartTime(), "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getEndTime(), "\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/track/getdistance", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String track(String appId, GetTrackParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getEntityName(), "entity\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getStartTime(), "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getEndTime(), "\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/track/gettrack", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String analyze(String appId, StayPointAnalysisParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getEntityName(), "entity\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getStartTime(), "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getEndTime(), "\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/analysis/staypoint", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String analyze(String appId, DrivingBehaviorAnalysisParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getEntityName(), "entity\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getStartTime(), "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getEndTime(), "\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/analysis/drivingbehavior", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String createFence(String appId, CreateCircleFenceRequest request) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getLongitude(), "\u4e2d\u5fc3\u70b9\u5750\u6807\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getLatitude(), "\u4e2d\u5fc3\u70b9\u5750\u6807\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getRadius(), "\u534a\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getCoordType(), "\u5750\u6807\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/fence/createcirclefence", appId, request, null, HttpMethodName.POST).getPayload();
    }

    public String createFence(String appId, CreatePolygonFenceRequest request) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getVertexes(), "\u8fb9\u754c\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getCoordType(), "\u5750\u6807\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/fence/createpolygonfence", appId, request, null, HttpMethodName.POST).getPayload();
    }

    public String createFence(String appId, CreatePolylineFenceRequest request) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getVertexes(), "\u8fb9\u754c\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getOffset(), "\u504f\u79fb\u8ddd\u79bb\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getCoordType(), "\u5750\u6807\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/fence/createpolylinefence", appId, request, null, HttpMethodName.POST).getPayload();
    }

    public String createFence(String appId, CreateDistrictFenceRequest request) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getKeyword(), "\u884c\u653f\u533a\u5212\u5173\u952e\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/fence/createdistrictfence", appId, request, null, HttpMethodName.POST).getPayload();
    }

    public String updateFence(String appId, UpdateCircleFenceRequest request) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getFenceId(), "\u56f4\u680fID\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/fence/updatecirclefence", appId, request, null, HttpMethodName.POST).getPayload();
    }

    public String updateFence(String appId, UpdatePolygonFenceRequest request) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getFenceId(), "\u56f4\u680fID\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/fence/updatepolygonfence", appId, request, null, HttpMethodName.POST).getPayload();
    }

    public String updateFence(String appId, UpdatePolylineFenceRequest request) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getFenceId(), "\u56f4\u680fID\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/fence/updatepolylinefence", appId, request, null, HttpMethodName.POST).getPayload();
    }

    public String updateFence(String appId, UpdateDistrictFenceRequest request) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getFenceId(), "\u56f4\u680fID\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/fence/updatedistrictfence", appId, request, null, HttpMethodName.POST).getPayload();
    }

    public String deleteFence(String appId, DeleteFenceRequest request) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/fence/delete", appId, request, null, HttpMethodName.POST).getPayload();
    }

    public String listFence(String appId, ListFenceParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/fence/list", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String addMonitoredPerson(String appId, AddMonitoredPersonRequest request) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getFenceId(), "\u56f4\u680fID\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getMonitoredPerson(), "\u76d1\u63a7\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/fence/addmonitoredperson", appId, request, null, HttpMethodName.POST).getPayload();
    }

    public String deleteMonitoredPerson(String appId, DeleteMonitoredPersonRequest request) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getFenceId(), "\u56f4\u680fID\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getMonitoredPerson(), "\u76d1\u63a7\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/fence/deletemonitoredperson", appId, request, null, HttpMethodName.POST).getPayload();
    }

    public String listMonitoredPerson(String appId, ListMonitoredPersonParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getFenceId(), "\u56f4\u680fID\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/fence/listmonitoredperson", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String queryStatus(String appId, QueryStatusParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkStringNotEmpty(param.getMonitoredPerson(), "\u76d1\u63a7\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/fence/querystatus", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String queryStatus(String appId, QueryStatusByLocationParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkStringNotEmpty(param.getMonitoredPerson(), "\u76d1\u63a7\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getLongitude(), "\u5750\u6807\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getLatitude(), "\u5750\u6807\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkStringNotEmpty(param.getCoordType(), "\u5750\u6807\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/fence/querystatusbylocation", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String historyAlarm(String appId, HistoryAlarmParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkStringNotEmpty(param.getMonitoredPerson(), "\u76d1\u63a7\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/fence/historyalarm", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String historyAlarm(String appId, BatchHistoryAlarmParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getStartTime(), "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getEndTime(), "\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/fence/batchhistoryalarm", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String setCallbackUrl(String appId, SetCallbackUrlRequest request) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkStringNotEmpty(request.getUrl(), "url\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/fence/seturl", appId, request, null, HttpMethodName.POST).getPayload();
    }

    public String cancelCallbackUrl(String appId, CancelCallbackUrlRequest request) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/fence/cancelurl", appId, request, null, HttpMethodName.POST).getPayload();
    }

    public String queryCallbackUrl(String appId, QueryCallbackUrlParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/fence/queryurl", appId, null, param, HttpMethodName.GET).getPayload();
    }

    public String createExportJob(String appId, CreateJobRequest request) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getStartTime(), "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getEndTime(), "\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/export/createjob", appId, request, null, HttpMethodName.POST).getPayload();
    }

    public String deleteExportJob(String appId, DeleteJobRequest request) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(request.getJobId(), "\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/export/deletejob", appId, request, null, HttpMethodName.POST).getPayload();
    }

    public String getExportJob(String appId, GetJobParam param) {
        Validate.checkStringNotEmpty(appId, "appId\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.checkNotNull(param.getServiceId(), "serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        return this.callDuMap(this.uriPrefix + "/v3/export/getjob", appId, null, param, HttpMethodName.GET).getPayload();
    }
}

