/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.dumap;

import com.baidubce.BceClientConfiguration;
import com.baidubce.http.HttpMethodName;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.dumap.BaseDuMapClient;
import com.baidubce.services.dumap.trace.service.CreateServiceRequest;
import com.baidubce.services.dumap.trace.service.DeleteServiceParam;
import com.baidubce.services.dumap.trace.service.DetailServiceParam;
import com.baidubce.services.dumap.trace.service.ListServiceParam;
import com.baidubce.services.dumap.trace.service.UpdateServiceRequest;
import java.lang.reflect.Field;

public class DuMapTraceServiceClient
extends BaseDuMapClient {
    private static final String TRACE_SERVICE_ENDPOINT = "http://dumap.baidubce.com";

    public DuMapTraceServiceClient() {
        this(new BceClientConfiguration().withEndpoint(TRACE_SERVICE_ENDPOINT));
    }

    public DuMapTraceServiceClient(BceClientConfiguration configuration) {
        super(configuration.getEndpoint() == null ? configuration.withEndpoint(TRACE_SERVICE_ENDPOINT) : configuration);
    }

    @Override
    protected void fillParams(InternalRequest request, Object obj) {
        Field[] fields;
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                if (field.get(obj) == null || "".equals(field.get(obj).toString())) continue;
                this.safeAddQueryParam(request, field.getName(), field.get(obj).toString());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void fillInHeadAndBody(AbstractBceRequest bceRequest, InternalRequest request, BaseDuMapClient.BodyType bodyType) {
        byte[] content = bodyType.equals((Object)BaseDuMapClient.BodyType.JSON) ? this.toJson(bceRequest) : this.toForm(bceRequest);
        request.addHeader("Content-Length", Integer.toString(content.length));
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        if (bceRequest instanceof CreateServiceRequest) {
            request.addParameter("create", null);
        } else if (bceRequest instanceof UpdateServiceRequest) {
            request.addParameter("update", null);
        }
        request.setContent(RestartableInputStream.wrap(content));
    }

    public String createService(CreateServiceRequest request) {
        return this.callDuMap("/v1/trace/service", request.getAppId(), request, null, HttpMethodName.POST, BaseDuMapClient.BodyType.JSON).getPayload();
    }

    public void updateService(UpdateServiceRequest request) {
        this.callDuMap("/v1/trace/service", request.getAppId(), request, null, HttpMethodName.POST, BaseDuMapClient.BodyType.JSON);
    }

    public void deleteService(DeleteServiceParam param) {
        this.callDuMap("/v1/trace/service", param.getAppId(), null, param, HttpMethodName.DELETE);
    }

    public String detailService(DetailServiceParam param) {
        return this.callDuMap("/v1/trace/service/detail", param.getAppId(), null, param, HttpMethodName.GET).getPayload();
    }

    public String listService(ListServiceParam param) {
        return this.callDuMap("/v1/trace/service/list", param.getAppId(), null, param, HttpMethodName.GET).getPayload();
    }
}

