/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestorage.model;

import com.baidubce.BceClientException;
import com.baidubce.services.tablestorage.model.AbstractTableStorageRequest;
import com.baidubce.services.tablestorage.model.CompressType;
import com.baidubce.services.tablestorage.model.TableOption;

public class CreateTableRequest
extends AbstractTableStorageRequest {
    private TableOption tableOption;

    public CreateTableRequest(String tableName, TableOption option) {
        super(tableName);
        this.tableOption = option;
    }

    @Override
    public String toJsonString() {
        StringBuffer buffer = new StringBuffer("{");
        buffer.append("\"tableVersion\":");
        if (this.tableOption.getTableVersion() != 0L) {
            throw new BceClientException("The tableVersion's value must be 0 in CreateTableRequest.");
        }
        buffer.append(this.tableOption.getTableVersion());
        buffer.append(",\"compressType\":\"");
        if (this.tableOption.getCompressType() != CompressType.DEFAULT) {
            buffer.append(this.tableOption.getCompressType().toString());
        } else {
            buffer.append(CompressType.NONE.toString());
        }
        buffer.append("\"");
        buffer.append(",\"ttl\":");
        long timeToLive = this.tableOption.getTimeToLive();
        if (timeToLive >= 0L) {
            buffer.append(this.tableOption.getTimeToLive());
        } else if (timeToLive == -1L) {
            buffer.append(0);
        } else {
            throw new BceClientException("The timeToLive's value cannot be a negative number other than DEFAULT_LIVE_TIME -1. timeToLive=" + timeToLive + ".");
        }
        buffer.append(",\"maxVersions\":");
        int maxVersions = this.tableOption.getMaxVersions();
        if (maxVersions > 0) {
            buffer.append(this.tableOption.getMaxVersions());
        } else if (this.tableOption.getMaxVersions() == 0) {
            buffer.append(0);
        } else {
            throw new BceClientException("The maxVersions' value must be positive, or equal to DEFAULT_TABLE_MAX_VERSIONS 0. maxVersions=" + maxVersions + ".");
        }
        buffer.append("}");
        return buffer.toString();
    }
}

