/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestorage.model.transform;

import com.baidubce.BceClientException;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.tablestorage.model.ListTablesResponse;
import com.baidubce.services.tablestorage.model.TableState;
import com.baidubce.services.tablestorage.model.transform.Unmarshaller;
import com.baidubce.services.tablestorage.model.transform.Unmarshallers;
import com.baidubce.util.JsonUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class ListTablesResponseUnmarshaller
implements Unmarshaller<ListTablesResponse, InputStream> {
    private ListTablesResponse result;

    public ListTablesResponseUnmarshaller(AbstractBceResponse response) {
        this.result = (ListTablesResponse)response;
    }

    @Override
    public ListTablesResponse unmarshall(InputStream in) throws Exception {
        String streamContents = Unmarshallers.readStreamContents(in);
        JsonNode root = JsonUtils.jsonNodeOf(streamContents);
        if (!root.isObject()) {
            throw new BceClientException("The input json object:" + root.toString() + " is not an object.");
        }
        JsonNode tableObj = root.get("tables");
        ArrayList<ListTablesResponse.TableInfo> tableInfos = new ArrayList<ListTablesResponse.TableInfo>();
        if (tableObj != null) {
            Iterator tableList = tableObj.elements();
            while (tableList.hasNext()) {
                JsonNode table = (JsonNode)tableList.next();
                String name = table.get("tableName").asText();
                String state = table.get("tableState").asText();
                long version = table.get("tableVersion").asLong();
                ListTablesResponse.TableInfo info = new ListTablesResponse.TableInfo();
                info.setTableName(name);
                info.setTableState(TableState.valueOf(state));
                info.setTableVersion(version);
                tableInfos.add(info);
            }
        }
        this.result.setTables(tableInfos);
        return this.result;
    }
}

