/*
 * Copyright (c) 2014 Baidu.com, Inc. All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.bcc.model.image;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * The request for creating new image.
 *
 */
public class CreateImageRequest extends AbstractBceRequest {

    /**
     * An ASCII string whose length is less than 64.
     * The request will be idempotent if client token is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BCC/API.html#.E9.80.9A.E7.94.A8.E8.AF.B4.E6.98.8E">
     *     BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;

    /**
     * The name for the image that will be created.
     * The name length from 1 to 65,only contains letters,digital and underline.
     */
    private String imageName;

    /**
     * The optional parameter specify the id of the instance which will be used to create the new image.
     * When instanceId and snapshotId are specified ,only instanceId will be used.
     */
    private String instanceId;

    /**
     * The optional parameter specify the id of the snapshot which will be used to create the new image.
     * When instanceId and snapshotId are specified ,only instanceId will be used.
     */
    private String snapshotId;

    public String getClientToken() {
        return clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    /**
     * Configure optional client token for the request. The request will be idempotent if client token is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     *
     * @param clientToken An ASCII string whose length is less than 64.
     *                    See more detail at
     *                    <a href = "https://bce.baidu.com/doc/BCC/API.html#.E9.80.9A.E7.94.A8.E8.AF.B4.E6.98.8E">
     *                        BCE API doc</a>
     * @return CreateImageRequest with specific clientToken
     */
    public CreateImageRequest withClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    public String getImageName() {
        return imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    /**
     * Configure imageName for the request.
     *
     * @param imageName  The name for the image that will be created.
     *                   The name length from 1 to 65,only contains letters,digital and underline.
     * @return CreateImageRequest with imageName.
     */
    public CreateImageRequest withImageName(String imageName) {
        this.imageName = imageName;
        return this;
    }

    public String getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    /**
     * Configure instanceId for the request.
     *
     * @param instanceId The optional parameter specify the id of the instance
     *                   which will be used to create the new image.
     *                   When instanceId and snapshotId are specified ,only instanceId will be used.
     * @return CreateImageRequest with instanceId.
     */
    public CreateImageRequest withInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public String getSnapshotId() {
        return snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    /**
     * Configure snapshotId for the request.
     *
     * @param snapshotId The optional parameter specify the id of the snapshot
     *                   which will be used to create the new image.
     *                   When instanceId and snapshotId are specified ,only instanceId will be used.
     * @return CreateImageRequest with snapshotId.
     */
    public CreateImageRequest withSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
        return this;
    }

    /**
     * Configure request credential for the request.
     *
     * @param credentials a valid instance of BceCredentials.
     * @return CreateImageRequest with credentials.
     */
    @Override
    public CreateImageRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
