/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.billing.example;

import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.billing.BillingClient;
import com.baidubce.services.billing.BillingClientConfiguration;
import com.baidubce.services.billing.model.ResourceMonthBillRequest;
import com.baidubce.services.billing.model.ResourceMonthBillResponse;
import com.baidubce.services.billing.model.order.OrderListRequest;
import com.baidubce.services.billing.model.order.OrderListResponse;
import com.baidubce.services.billing.model.price.ChargeItem;
import com.baidubce.services.billing.model.price.CpcPricingRequest;
import com.baidubce.services.billing.model.price.CptPricingRequest;
import com.baidubce.services.billing.model.price.Flavor;
import com.baidubce.services.billing.model.price.PricingQueryResponse;
import java.math.BigDecimal;
import java.util.ArrayList;

public class BillingExample {
    private static final String ACCESS_KEY_ID = "ak ";
    private static final String SECRET_ACCESS_KEY = "sk ";
    private static final String ENDPOINT = "https://billing endpoint";

    public static void main(String[] args) {
        BillingExample.sampleForGetResourceMonthBills();
        BillingExample.sampleForQueryOrderList();
        BillingExample.sampleForgetSpecificCptPrice();
        BillingExample.sampleForgetSpecificCpcPrice();
    }

    private static void sampleForGetResourceMonthBills() {
        DefaultBceCredentials credentials = new DefaultBceCredentials(ACCESS_KEY_ID, SECRET_ACCESS_KEY);
        BillingClient client = new BillingClient(new BillingClientConfiguration().withEndpoint(ENDPOINT).withCredentials(credentials));
        ResourceMonthBillRequest request = new ResourceMonthBillRequest();
        request.setMonth("2019-04");
        request.setProductType("postpay");
        request.setPageNo(1);
        request.setPageSize(50);
        ResourceMonthBillResponse response = client.getResourceMonthBill(request);
        System.out.println("==================================");
        System.out.println("sampleForGetResourceMonthBills ResourceMonthBillResponse result:");
        System.out.println("    accountid:  " + response.getAccountId());
        System.out.println("    month:  " + response.getBillMonth());
        System.out.println("    size:  " + response.getTotalCount());
        System.out.println("    bills:  " + response.getBills());
        System.out.println("==================================");
    }

    private static void sampleForQueryOrderList() {
        DefaultBceCredentials credentials = new DefaultBceCredentials(ACCESS_KEY_ID, SECRET_ACCESS_KEY);
        BillingClient client = new BillingClient(new BillingClientConfiguration().withEndpoint(ENDPOINT).withCredentials(credentials));
        OrderListRequest request = new OrderListRequest();
        request.setProductType("postpay");
        request.setPageNo(1);
        request.setPageSize(50);
        OrderListResponse response = client.getOrderList(request);
        System.out.println("==================================");
        System.out.println("sampleForQueryOrderList OrderListResponse result:");
        System.out.println("    pageno:  " + response.getPageNo());
        System.out.println("    pagesize:  " + response.getPageSize());
        System.out.println("    size:  " + response.getTotalCount());
        System.out.println("    orders:  " + response.getOrders());
        System.out.println("==================================");
    }

    private static void sampleForgetSpecificCptPrice() {
        DefaultBceCredentials credentials = new DefaultBceCredentials(ACCESS_KEY_ID, SECRET_ACCESS_KEY);
        BillingClient client = new BillingClient(new BillingClientConfiguration().withEndpoint(ENDPOINT).withCredentials(credentials));
        Flavor flavor = new Flavor();
        ArrayList<ChargeItem> items = new ArrayList<ChargeItem>();
        items.add(new ChargeItem("memory", "1g", BigDecimal.valueOf(8L)));
        items.add(new ChargeItem("physicalZone", "zone id", BigDecimal.valueOf(8L)));
        items.add(new ChargeItem("cpu", "1", BigDecimal.valueOf(2L)));
        items.add(new ChargeItem("subServiceType", "defaultBcc3", null));
        flavor.setChargeItems(items);
        CptPricingRequest request = new CptPricingRequest();
        request.setServiceType("BCC");
        request.setProductType("RESERVED");
        request.setRegion("bj");
        request.setFlavor(flavor);
        request.setCount(1);
        request.setPeriod("P1M");
        PricingQueryResponse response = client.getSpecificCptPrice(request);
        System.out.println("==================================");
        System.out.println("sampleForgetSpecificCptPrice PricingQueryResponse result:");
        System.out.println("    price:  " + response.getPrice());
        System.out.println("    catalogPrice:  " + response.getCatalogPrice());
        System.out.println("==================================");
    }

    private static void sampleForgetSpecificCpcPrice() {
        DefaultBceCredentials credentials = new DefaultBceCredentials(ACCESS_KEY_ID, SECRET_ACCESS_KEY);
        BillingClient client = new BillingClient(new BillingClientConfiguration().withEndpoint(ENDPOINT).withCredentials(credentials));
        Flavor flavor = new Flavor();
        ArrayList<ChargeItem> items = new ArrayList<ChargeItem>();
        items.add(new ChargeItem("OutBytes", "10G", null));
        flavor.setChargeItems(items);
        CpcPricingRequest request = new CpcPricingRequest();
        request.setServiceType("LSS");
        request.setProductType("ON_DEMAND");
        request.setRegion("global");
        request.setFlavor(flavor);
        request.setCount(1);
        PricingQueryResponse response = client.getSpecificCpcPrice(request);
        System.out.println("==================================");
        System.out.println("sampleForgetSpecificCpcPrice PricingQueryResponse result:");
        System.out.println("    price:  " + response.getPrice());
        System.out.println("    catalogPrice:  " + response.getCatalogPrice());
        System.out.println("==================================");
    }
}

