/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bvw.model.media;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;

public class MediaProcessRequest
extends AbstractBceRequest {
    private String mediaId;
    private String sourceBucket;
    private String sourceKey;
    private String title;
    private String description;
    private String workflowName;
    private String dynamicParams;

    public static MediaProcessRequest of(String sourceBucket, String sourceKey, String title, String description, String workflowName, String dynamicParams) {
        MediaProcessRequest processRequest = new MediaProcessRequest();
        processRequest.setSourceBucket(sourceBucket);
        processRequest.setSourceKey(sourceKey);
        processRequest.setTitle(title);
        processRequest.setDescription(description);
        processRequest.setWorkflowName(workflowName);
        processRequest.setDynamicParams(dynamicParams);
        return processRequest;
    }

    public static MediaProcessRequest of(String sourceBucket, String sourceKey, String title, String description, String workflowName) {
        return MediaProcessRequest.of(sourceBucket, sourceKey, title, description, workflowName, null);
    }

    public static MediaProcessRequest of(String mediaId, String workflowName, String dynamicParams) {
        MediaProcessRequest processRequest = new MediaProcessRequest();
        processRequest.setMediaId(mediaId);
        processRequest.setWorkflowName(workflowName);
        processRequest.setDynamicParams(dynamicParams);
        return processRequest;
    }

    public static MediaProcessRequest of(String mediaId, String workflowName) {
        return MediaProcessRequest.of(mediaId, workflowName, null);
    }

    @Override
    public MediaProcessRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public String getSourceBucket() {
        return this.sourceBucket;
    }

    public void setSourceBucket(String sourceBucket) {
        this.sourceBucket = sourceBucket;
    }

    public String getSourceKey() {
        return this.sourceKey;
    }

    public void setSourceKey(String sourceKey) {
        this.sourceKey = sourceKey;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public String getDynamicParams() {
        return this.dynamicParams;
    }

    public void setDynamicParams(String dynamicParams) {
        this.dynamicParams = dynamicParams;
    }
}

