/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.qianfan.core;

import com.baidubce.qianfan.core.QianfanConfig;
import com.baidubce.qianfan.core.auth.IAMAuth;
import com.baidubce.qianfan.core.auth.IAuth;
import com.baidubce.qianfan.model.console.ConsoleResponse;
import com.baidubce.qianfan.model.console.ListServiceRequest;
import com.baidubce.qianfan.model.console.ListServiceResponse;
import com.baidubce.qianfan.model.console.ServiceItem;
import com.baidubce.qianfan.model.exception.ValidationException;
import com.baidubce.qianfan.util.StringUtils;
import com.baidubce.qianfan.util.TypeRef;
import com.baidubce.qianfan.util.http.HttpClient;
import com.baidubce.qianfan.util.http.HttpResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModelEndpointRetriever {
    private static final String DEFAULT_CHAT_MODEL = "ernie-lite-8k";
    private static final String DEFAULT_COMPLETION_MODEL = "codellama-7b-instruct";
    private static final String DEFAULT_EMBEDDING_MODEL = "embedding-v1";
    private static final String DEFAULT_TEXT_2_IMAGE_MODEL = "stable-diffusion-xl";
    private static final String DEFAULT_IMAGE_2_TEXT_MODEL = "fuyu-8b";
    private static final String DEFAULT_RERANKER_MODEL = "bce-reranker-base_v1";
    private static final String LIST_MODEL_SERVICE_URL = "%s/wenxinworkshop/service/list";
    private static final String ENDPOINT_TEMPLATE = "/%s/%s";
    private static final int DYNAMIC_MAP_REFRESH_INTERVAL = 3600;
    private static final String[] MODEL_TYPES = new String[]{"chat", "completions", "embeddings", "text2image", "image2text", "reranker", "plugin"};
    private final Map<String, Map<String, String>> typeModelEndpointMap = new HashMap<String, Map<String, String>>();
    private final Map<String, String> defaultTypeModelMap = new HashMap<String, String>();
    private volatile Map<String, Map<String, String>> dynamicTypeModelEndpointMap = new HashMap<String, Map<String, String>>();
    private IAMAuth auth;
    private volatile long dynamicMapExpireAt;

    public ModelEndpointRetriever(IAuth auth) {
        if (auth instanceof IAMAuth) {
            this.auth = (IAMAuth)auth;
        }
        this.defaultTypeModelMap.put("chat", DEFAULT_CHAT_MODEL);
        this.defaultTypeModelMap.put("completions", DEFAULT_COMPLETION_MODEL);
        this.defaultTypeModelMap.put("embeddings", DEFAULT_EMBEDDING_MODEL);
        this.defaultTypeModelMap.put("text2image", DEFAULT_TEXT_2_IMAGE_MODEL);
        this.defaultTypeModelMap.put("image2text", DEFAULT_IMAGE_2_TEXT_MODEL);
        this.defaultTypeModelMap.put("reranker", DEFAULT_RERANKER_MODEL);
        for (String type : MODEL_TYPES) {
            this.typeModelEndpointMap.put(type, new HashMap());
            this.dynamicTypeModelEndpointMap.put(type, new HashMap());
        }
        this.typeModelEndpointMap.get("chat").put("ernie-4.0-turbo-8k", "ernie-4.0-turbo-8k");
        this.typeModelEndpointMap.get("chat").put("ernie-4.0-8k", "completions_pro");
        this.typeModelEndpointMap.get("chat").put("ernie-4.0-8k-preview", "ernie-4.0-8k-preview");
        this.typeModelEndpointMap.get("chat").put("ernie-4.0-8k-preview-0518", "completions_adv_pro");
        this.typeModelEndpointMap.get("chat").put("ernie-4.0-8k-latest", "ernie-4.0-8k-latest");
        this.typeModelEndpointMap.get("chat").put("ernie-4.0-8k-0329", "ernie-4.0-8k-0329");
        this.typeModelEndpointMap.get("chat").put("ernie-4.0-8k-0104", "ernie-4.0-8k-0104");
        this.typeModelEndpointMap.get("chat").put("ernie-4.0-8k-0613", "ernie-4.0-8k-0613");
        this.typeModelEndpointMap.get("chat").put("ernie-3.5-8k", "completions");
        this.typeModelEndpointMap.get("chat").put("ernie-3.5-8k-0205", "ernie-3.5-8k-0205");
        this.typeModelEndpointMap.get("chat").put("ernie-3.5-8k-preview", "ernie-3.5-8k-preview");
        this.typeModelEndpointMap.get("chat").put("ernie-3.5-8k-0329", "ernie-3.5-8k-0329");
        this.typeModelEndpointMap.get("chat").put("ernie-3.5-128k", "ernie-3.5-128k");
        this.typeModelEndpointMap.get("chat").put("ernie-3.5-8k-0613", "ernie-3.5-8k-0613");
        this.typeModelEndpointMap.get("chat").put("ernie-speed-8k", "ernie_speed");
        this.typeModelEndpointMap.get("chat").put("ernie-speed-128k", "ernie-speed-128k");
        this.typeModelEndpointMap.get("chat").put("ernie-speed-appbuilder", "ai_apaas");
        this.typeModelEndpointMap.get("chat").put("ernie-character-8k", "ernie-char-8k");
        this.typeModelEndpointMap.get("chat").put("ernie-character-fiction-8k", "ernie-char-fiction-8k");
        this.typeModelEndpointMap.get("chat").put("ernie-lite-8k-0922", "eb-instant");
        this.typeModelEndpointMap.get("chat").put(DEFAULT_CHAT_MODEL, DEFAULT_CHAT_MODEL);
        this.typeModelEndpointMap.get("chat").put("ernie-lite-appbuilder-8k-0614", "ai_apaas_lite");
        this.typeModelEndpointMap.get("chat").put("ernie-functions-8k", "ernie-func-8k");
        this.typeModelEndpointMap.get("chat").put("ernie-tiny-8k", "ernie-tiny-8k");
        this.typeModelEndpointMap.get("chat").put("gemma-7b-it", "gemma_7b_it");
        this.typeModelEndpointMap.get("chat").put("yi-34b-chat", "yi_34b_chat");
        this.typeModelEndpointMap.get("chat").put("bloomz-7b", "bloomz_7b1");
        this.typeModelEndpointMap.get("chat").put("qianfan-bloomz-7b-compressed", "qianfan_bloomz_7b_compressed");
        this.typeModelEndpointMap.get("chat").put("mixtral-8x7b-instruct", "mixtral_8x7b_instruct");
        this.typeModelEndpointMap.get("chat").put("llama-2-7b-chat", "llama_2_7b");
        this.typeModelEndpointMap.get("chat").put("llama-2-13b-chat", "llama_2_13b");
        this.typeModelEndpointMap.get("chat").put("llama-2-70b-chat", "llama_2_70b");
        this.typeModelEndpointMap.get("chat").put("meta-llama-3-8b-instruct", "llama_3_8b");
        this.typeModelEndpointMap.get("chat").put("meta-llama-3-70b-instruct", "llama_3_70b");
        this.typeModelEndpointMap.get("chat").put("qianfan-chinese-llama-2-7b", "qianfan_chinese_llama_2_7b");
        this.typeModelEndpointMap.get("chat").put("qianfan-chinese-llama-2-13b-v1", "qianfan_chinese_llama_2_13b");
        this.typeModelEndpointMap.get("chat").put("qianfan-chinese-llama-2-70b", "qianfan_chinese_llama_2_70b");
        this.typeModelEndpointMap.get("chat").put("chatglm2-6b-32k", "chatglm2_6b_32k");
        this.typeModelEndpointMap.get("chat").put("xuanyuan-70b-chat-4bit", "xuanyuan_70b_chat");
        this.typeModelEndpointMap.get("chat").put("chatlaw", "chatlaw");
        this.typeModelEndpointMap.get("chat").put("aquilachat-7b", "aquilachat_7b");
        this.typeModelEndpointMap.get("completions").put("sqlcoder-7b", "sqlcoder_7b");
        this.typeModelEndpointMap.get("completions").put(DEFAULT_COMPLETION_MODEL, "codellama_7b_instruct");
        this.typeModelEndpointMap.get("embeddings").put(DEFAULT_EMBEDDING_MODEL, DEFAULT_EMBEDDING_MODEL);
        this.typeModelEndpointMap.get("embeddings").put("bge-large-zh", "bge_large_zh");
        this.typeModelEndpointMap.get("embeddings").put("bge-large-en", "bge_large_en");
        this.typeModelEndpointMap.get("embeddings").put("tao-8k", "tao_8k");
        this.typeModelEndpointMap.get("text2image").put(DEFAULT_TEXT_2_IMAGE_MODEL, "sd_xl");
        this.typeModelEndpointMap.get("image2text").put(DEFAULT_IMAGE_2_TEXT_MODEL, "fuyu_8b");
        this.typeModelEndpointMap.get("reranker").put(DEFAULT_RERANKER_MODEL, "bce_reranker_base");
        this.typeModelEndpointMap.get("chat").put("ernie-bot-turbo", "eb-instant");
        this.typeModelEndpointMap.get("chat").put("ernie-bot", "completions");
        this.typeModelEndpointMap.get("chat").put("ernie-bot-4", "completions_pro");
        this.typeModelEndpointMap.get("chat").put("ernie-bot-8k", "ernie_bot_8k");
        this.typeModelEndpointMap.get("chat").put("ernie-speed", "ernie_speed");
        this.typeModelEndpointMap.get("chat").put("ernie speed-appbuilder", "ai_apaas");
        this.typeModelEndpointMap.get("chat").put("ernie-bot-turbo-ai", "ai_apaas");
        this.typeModelEndpointMap.get("chat").put("eb-turbo-appbuilder", "ai_apaas");
        this.typeModelEndpointMap.get("chat").put("qianfan-chinese-llama-2-13b", "qianfan_chinese_llama_2_13b");
        this.typeModelEndpointMap.get("chat").put("ernie-4.0-8k-preemptible", "completions_pro_preemptible");
        this.typeModelEndpointMap.get("chat").put("ernie-3.5-8k-preemptible", "completions_preemptible");
        this.typeModelEndpointMap.get("chat").put("ernie-3.5-8k-1222", "ernie-3.5-8k-1222");
        this.typeModelEndpointMap.get("chat").put("ernie-3.5-4k-0205", "ernie-3.5-4k-0205");
        this.typeModelEndpointMap.get("chat").put("ernie-character-8k-0321", "ernie-char-8k");
        this.typeModelEndpointMap.get("chat").put("ernie-lite-8k-0308", DEFAULT_CHAT_MODEL);
    }

    private static String parseEndpoint(String url) {
        String[] parts = url.split("/");
        return parts[parts.length - 1];
    }

    @SafeVarargs
    private static <K, V> V getFromMultiMap(K key, Map<K, V> ... maps) {
        for (Map<K, V> map : maps) {
            if (!map.containsKey(key)) continue;
            return map.get(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEndpoint(String type, String model, String endpoint) {
        if (this.isDynamicMapExpired()) {
            ModelEndpointRetriever modelEndpointRetriever = this;
            synchronized (modelEndpointRetriever) {
                if (this.isDynamicMapExpired()) {
                    this.updateDynamicModelEndpointMap();
                    this.dynamicMapExpireAt = System.currentTimeMillis() / 1000L + 3600L;
                }
            }
        }
        Map<String, String> endpointMap = this.typeModelEndpointMap.get(type);
        Map<String, String> dynamicEndpointMap = this.dynamicTypeModelEndpointMap.get(type);
        if (endpointMap == null) {
            throw new ValidationException("Type " + type + " is not supported");
        }
        if (StringUtils.isNotEmpty(endpoint)) {
            if ("plugin".equals(type)) {
                endpoint = endpoint + "/";
            }
            return String.format(ENDPOINT_TEMPLATE, type, endpoint);
        }
        if (StringUtils.isNotEmpty(model)) {
            String lowerCaseModel = model.toLowerCase();
            String modelEndpoint = (String)ModelEndpointRetriever.getFromMultiMap(lowerCaseModel, dynamicEndpointMap, endpointMap);
            if (modelEndpoint == null) {
                throw new IllegalArgumentException("Model " + model + " is not supported for " + type);
            }
            return String.format(ENDPOINT_TEMPLATE, type, modelEndpoint);
        }
        String defaultModel = this.defaultTypeModelMap.get(type);
        if (defaultModel == null) {
            throw new ValidationException("No default model for type " + type);
        }
        return String.format(ENDPOINT_TEMPLATE, type, ModelEndpointRetriever.getFromMultiMap(defaultModel, dynamicEndpointMap, endpointMap));
    }

    private boolean isDynamicMapExpired() {
        return System.currentTimeMillis() / 1000L > this.dynamicMapExpireAt;
    }

    private void updateDynamicModelEndpointMap() {
        String url = String.format(LIST_MODEL_SERVICE_URL, QianfanConfig.getConsoleApiBaseUrl());
        try {
            HttpResponse<ConsoleResponse<ListServiceResponse>> resp = this.auth.signRequest(HttpClient.request().post(url)).body(new ListServiceRequest()).executeJson(new TypeRef<ConsoleResponse<ListServiceResponse>>(){});
            if (resp.getCode() != 200) {
                return;
            }
            List<ServiceItem> services = resp.getBody().getResult().getCommon();
            if (services.isEmpty()) {
                return;
            }
            HashMap<String, Map<String, String>> newDynamicMap = new HashMap<String, Map<String, String>>();
            for (String type : MODEL_TYPES) {
                newDynamicMap.put(type, new HashMap());
            }
            for (ServiceItem service : services) {
                String apiType = service.getApiType();
                String model = service.getName();
                String endpoint = ModelEndpointRetriever.parseEndpoint(service.getUrl());
                Map modelEndpointMap = (Map)newDynamicMap.get(apiType);
                if (modelEndpointMap == null) continue;
                modelEndpointMap.put(model.toLowerCase(), endpoint);
            }
            this.dynamicTypeModelEndpointMap = newDynamicMap;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

