/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.qianfan.core;

import com.baidubce.qianfan.model.RateLimitConfig;
import com.baidubce.qianfan.model.exception.RequestException;
import com.baidubce.qianfan.model.exception.ValidationException;
import com.baidubce.qianfan.util.TokenBucketLimiter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RateLimiter {
    private final int qpsLimit;
    private final int rpmLimit;
    private final Map<String, TokenBucketLimiter> limiterMap = new ConcurrentHashMap<String, TokenBucketLimiter>();

    public RateLimiter(RateLimitConfig config) {
        this.qpsLimit = config.getQpsLimit();
        this.rpmLimit = config.getRpmLimit();
        if (this.qpsLimit > 0 && this.rpmLimit > 0) {
            throw new ValidationException("Only one of qpsLimit and rpmLimit can be set");
        }
        if (this.qpsLimit < 0 || this.rpmLimit < 0) {
            throw new ValidationException("qpsLimit and rpmLimit must be non-negative");
        }
    }

    public void acquire(String key) {
        TokenBucketLimiter limiter = this.getLimiter(key);
        if (limiter != null) {
            try {
                limiter.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RequestException("Rate limit acquire interrupted", e);
            }
        }
    }

    public void updateMaxTokens(String key, int maxTokens) {
        TokenBucketLimiter limiter = this.getLimiter(key);
        if (limiter != null) {
            limiter.updateMaxTokens(maxTokens, false);
        }
    }

    private TokenBucketLimiter getLimiter(String key) {
        return this.limiterMap.computeIfAbsent(key, k -> {
            if (this.qpsLimit > 0) {
                return new TokenBucketLimiter(this.qpsLimit, 1);
            }
            if (this.rpmLimit > 0) {
                return new TokenBucketLimiter(this.rpmLimit, 60);
            }
            return null;
        });
    }
}

