/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.qianfan.core.auth;

import com.baidubce.qianfan.core.QianfanConfig;
import com.baidubce.qianfan.core.auth.IAMAuth;
import com.baidubce.qianfan.core.auth.IAuth;
import com.baidubce.qianfan.core.auth.QianfanOAuth;
import com.baidubce.qianfan.model.exception.ValidationException;
import com.baidubce.qianfan.util.StringUtils;

public class Auth {
    public static final String TYPE_IAM = "IAM";
    public static final String TYPE_OAUTH = "OAuth";

    private Auth() {
    }

    public static IAuth create() {
        String accessKey = QianfanConfig.getQianfanAccessKey();
        String secretKey = QianfanConfig.getQianfanSecretKey();
        if (StringUtils.isNotEmpty(accessKey) && StringUtils.isNotEmpty(secretKey)) {
            return Auth.create(TYPE_IAM, accessKey, secretKey);
        }
        String qianfanAK = QianfanConfig.getQianfanAk();
        String qianfanSK = QianfanConfig.getQianfanSk();
        if (StringUtils.isNotEmpty(qianfanAK) && StringUtils.isNotEmpty(qianfanSK)) {
            return Auth.create(TYPE_OAUTH, qianfanAK, qianfanSK);
        }
        throw new ValidationException("No access key or secret key found in environment variables");
    }

    public static IAuth create(String accessKey, String secretKey) {
        return Auth.create(TYPE_IAM, accessKey, secretKey);
    }

    public static IAuth create(String type, String accessKey, String secretKey) {
        if (TYPE_IAM.equals(type)) {
            return new IAMAuth(accessKey, secretKey);
        }
        if (TYPE_OAUTH.equals(type)) {
            return new QianfanOAuth(accessKey, secretKey);
        }
        throw new ValidationException("Unsupported auth type: " + type);
    }
}

