/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.qianfan.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollUtils {
    private CollUtils() {
    }

    public static <K, V> Map<K, V> mapOf(Object ... keyValues) {
        if (keyValues.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid key-value pairs");
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        for (int i = 0; i < keyValues.length; i += 2) {
            Object key = keyValues[i];
            Object value = keyValues[i + 1];
            if (key == null) {
                throw new IllegalArgumentException("Key at index " + i + " is null");
            }
            map.put(key, value);
        }
        return map;
    }

    @SafeVarargs
    public static <T> List<T> listOf(T ... values) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, values);
        return list;
    }

    @SafeVarargs
    public static <T> T[] arrayOf(T ... values) {
        return values;
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T ... values) {
        LinkedHashSet set = new LinkedHashSet();
        Collections.addAll(set, values);
        return set;
    }
}

