/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.client;

import com.bfd.harpc.RpcException;
import com.bfd.harpc.client.Invoker;
import com.bfd.harpc.common.ServerNode;
import com.bfd.harpc.loadbalance.LoadBalancer;
import com.bfd.harpc.loadbalance.RequestTracker;
import com.bfd.harpc.loadbalance.common.DynamicHostSet;
import com.bfd.harpc.monitor.RpcMonitor;
import com.bfd.harpc.monitor.StatisticsInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketException;
import org.apache.avro.AvroRemoteException;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInvoker<T>
implements Invoker {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final GenericKeyedObjectPool<ServerNode, T> pool;
    private final LoadBalancer<ServerNode> loadBalancer;
    private final int retry;
    private final RpcMonitor monitor;
    private final ServerNode clientNode;
    private final DynamicHostSet hostSet;

    public DefaultInvoker(ServerNode clientNode, GenericKeyedObjectPool<ServerNode, T> pool, LoadBalancer<ServerNode> loadBalancer, int retry, RpcMonitor monitor, DynamicHostSet hostSet) {
        this.clientNode = clientNode;
        this.pool = pool;
        this.loadBalancer = loadBalancer;
        this.retry = retry;
        this.monitor = monitor;
        this.hostSet = hostSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Object invoke(Method method, Object[] args) throws RpcException {
        Object client = null;
        ServerNode serverNode = null;
        Throwable exception = null;
        for (int i = 0; i == 0 || i < this.retry + 1; ++i) {
            Object object;
            StatisticsInfo info;
            long startTime;
            block32: {
                block30: {
                    block31: {
                        startTime = System.currentTimeMillis();
                        info = new StatisticsInfo();
                        serverNode = this.loadBalancer.nextBackend();
                        if (serverNode != null) break block30;
                        if (client == null) break block31;
                        try {
                            this.pool.returnObject((Object)serverNode, client);
                        }
                        catch (Exception e) {
                            this.LOGGER.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    if (this.monitor == null) continue;
                    long usetime = System.currentTimeMillis() - startTime;
                    info.setAvgtime(usetime);
                    info.setMaxtime(usetime);
                    info.setMintime(usetime);
                    this.monitor.collect(this.clientNode, info);
                    continue;
                }
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug("Invoke to {}.", (Object)serverNode);
                }
                client = this.pool.borrowObject((Object)serverNode);
                Object result = method.invoke(client, args);
                this.loadBalancer.requestResult(serverNode, RequestTracker.RequestResult.SUCCESS, System.currentTimeMillis() - startTime);
                info.setSuccess(1L);
                object = result;
                if (client == null) break block32;
                try {
                    this.pool.returnObject((Object)serverNode, client);
                }
                catch (Exception e) {
                    this.LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            if (this.monitor != null) {
                long usetime = System.currentTimeMillis() - startTime;
                info.setAvgtime(usetime);
                info.setMaxtime(usetime);
                info.setMintime(usetime);
                this.monitor.collect(this.clientNode, info);
            }
            return object;
            catch (InvocationTargetException ite) {
                block33: {
                    Throwable cause = ite.getCause();
                    if (cause != null) {
                        if (cause instanceof TTransportException || cause instanceof AvroRemoteException) {
                            this.loadBalancer.requestResult(serverNode, RequestTracker.RequestResult.TIMEOUT, System.currentTimeMillis() - startTime);
                            this.hostSet.addDeadInstance(serverNode);
                            info.setFailure(1L);
                            exception = cause;
                            try {
                                if (cause.getCause() != null && cause.getCause() instanceof SocketException) {
                                    this.pool.clear((Object)serverNode);
                                } else {
                                    this.pool.invalidateObject((Object)serverNode, client);
                                }
                            }
                            catch (Exception e) {
                                this.LOGGER.error(e.getMessage(), (Throwable)e);
                            }
                            client = null;
                        } else {
                            this.loadBalancer.requestResult(serverNode, RequestTracker.RequestResult.FAILED, System.currentTimeMillis() - startTime);
                            info.setFailure(1L);
                            exception = cause;
                        }
                    } else {
                        this.loadBalancer.requestResult(serverNode, RequestTracker.RequestResult.FAILED, System.currentTimeMillis() - startTime);
                        info.setFailure(1L);
                        exception = ite;
                    }
                    if (client == null) break block33;
                    try {
                        this.pool.returnObject((Object)serverNode, client);
                    }
                    catch (Exception e) {
                        this.LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
                if (this.monitor == null) continue;
                long usetime2 = System.currentTimeMillis() - startTime;
                info.setAvgtime(usetime2);
                info.setMaxtime(usetime2);
                info.setMintime(usetime2);
                this.monitor.collect(this.clientNode, info);
                continue;
            }
            catch (Throwable e) {
                block34: {
                    this.loadBalancer.requestResult(serverNode, RequestTracker.RequestResult.FAILED, System.currentTimeMillis() - startTime);
                    info.setFailure(1L);
                    exception = e;
                    if (client == null) break block34;
                    {
                        catch (Throwable throwable) {
                            if (client != null) {
                                try {
                                    this.pool.returnObject((Object)serverNode, client);
                                }
                                catch (Exception e2) {
                                    this.LOGGER.error(e2.getMessage(), (Throwable)e2);
                                }
                            }
                            if (this.monitor != null) {
                                long usetime3 = System.currentTimeMillis() - startTime;
                                info.setAvgtime(usetime3);
                                info.setMaxtime(usetime3);
                                info.setMintime(usetime3);
                                this.monitor.collect(this.clientNode, info);
                            }
                            throw throwable;
                        }
                    }
                    try {
                        this.pool.returnObject((Object)serverNode, client);
                    }
                    catch (Exception e3) {
                        this.LOGGER.error(e3.getMessage(), (Throwable)e3);
                    }
                }
                if (this.monitor == null) continue;
                long usetime4 = System.currentTimeMillis() - startTime;
                info.setAvgtime(usetime4);
                info.setMaxtime(usetime4);
                info.setMintime(usetime4);
                this.monitor.collect(this.clientNode, info);
                continue;
            }
        }
        throw new RpcException("Invoke error!", exception);
    }
}

