/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.common;

import com.google.common.base.Objects;
import org.apache.commons.lang.StringUtils;

public class ServerNode {
    private String ip;
    private int port;
    private String ext;

    public ServerNode(String ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public ServerNode(String ip, int port, String ext) {
        this.ip = ip;
        this.port = port;
        this.ext = ext;
    }

    public static ServerNode fromParts(String host, int port) {
        return new ServerNode(host, port);
    }

    public String genAddress() {
        return this.ip + ":" + this.port + (StringUtils.isEmpty((String)this.ext) ? "" : ":" + this.ext);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ServerNode) {
            ServerNode that = (ServerNode)other;
            return Objects.equal((Object)this.ip, (Object)that.ip) && this.port == that.port && Objects.equal((Object)this.ext, (Object)that.ext);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ip, this.port, this.ext});
    }

    public String toString() {
        return "ServerNode [ip=" + this.ip + ", port=" + this.port + "]";
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getExt() {
        return this.ext;
    }

    public void setExt(String ext) {
        this.ext = ext;
    }
}

