/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.common.configure;

import com.bfd.harpc.common.configure.ResourceConstants;
import com.bfd.harpc.common.configure.ResourceUtils;
import com.bfd.harpc.common.configure.SeparatorUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class PathUtils {
    public static String cleanPath(String path) {
        int i;
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        if (path.startsWith("jar:file")) {
            path = PathUtils.cleanJarPath(path);
        }
        String pathToUse = StringUtils.replace((String)path, (String)ResourceConstants.WINDOWS_FOLDER_SEPARATOR.getValue(), (String)ResourceConstants.FOLDER_SEPARATOR.getValue());
        int prefixIndex = pathToUse.indexOf(":");
        String prefix = "";
        if (prefixIndex != -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            pathToUse = pathToUse.substring(prefixIndex + 1);
        }
        if (pathToUse.startsWith(ResourceConstants.FOLDER_SEPARATOR.getValue())) {
            prefix = prefix + ResourceConstants.FOLDER_SEPARATOR.getValue();
            pathToUse = pathToUse.substring(1);
        }
        String[] pathArray = StringUtils.split((String)pathToUse, (String)ResourceConstants.FOLDER_SEPARATOR.getValue());
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (i = pathArray.length - 1; i >= 0; --i) {
            String element = pathArray[i];
            if (ResourceConstants.CURRENT_PATH.getValue().equals(element)) continue;
            if (ResourceConstants.TOP_PATH.getValue().equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        for (i = 0; i < tops; ++i) {
            pathElements.add(0, ResourceConstants.TOP_PATH.getValue());
        }
        return prefix + StringUtils.join(pathElements, (String)ResourceConstants.FOLDER_SEPARATOR.getValue());
    }

    public static String cleanJarPath(String original) {
        original = original.substring(4);
        int index = original.indexOf("!");
        String left = original.substring(0, index);
        String right = original.substring(index + 1);
        index = left.lastIndexOf("/");
        left = left.substring(0, index);
        return left + right;
    }

    public static URL cleanPath(URL originalUrl) throws MalformedURLException, URISyntaxException {
        String path = originalUrl.toString();
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        URL curl = new URL(PathUtils.cleanPath(path));
        return new URL(curl.getProtocol(), curl.getHost(), curl.toURI().getPath());
    }

    public static String getRealPath(URL originalUrl) {
        String fs = SeparatorUtils.getFileSeparator();
        String file = originalUrl.getFile();
        if (fs.equals("\\")) {
            return file.replace("/", fs);
        }
        return file;
    }

    public static String getRealPath(String locationPattern) throws IOException, URISyntaxException {
        URL url = ResourceUtils.loadResource(locationPattern);
        return PathUtils.getRealPath(url);
    }

    public static String getAppDir(Class<?> clazz) {
        try {
            File f = new File(PathUtils.getCodeLocation(clazz).toURI().getPath());
            return f.isFile() ? f.getParent() : f.getPath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL getCodeLocation(Class<?> clazz) {
        URL r;
        URL codeLocation = null;
        URL uRL = r = clazz.getResource("");
        synchronized (uRL) {
            String s = r.toString();
            Pattern jrare = Pattern.compile("jar:\\s?(.*)!/.*");
            Matcher m = jrare.matcher(s);
            if (m.find()) {
                s = m.group(1);
            } else {
                String p = clazz.getPackage().getName().replace('.', '/');
                s = s.substring(0, s.lastIndexOf(p));
            }
            try {
                codeLocation = new URL(s);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return codeLocation;
    }
}

