/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.common.configure;

import com.bfd.harpc.common.configure.PathUtils;
import com.bfd.harpc.common.configure.ResourceUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class PropertiesConfiguration
extends Properties {
    private static final long serialVersionUID = 5889693716376287459L;
    private static Map<String, PropertiesConfiguration> properties = new ConcurrentHashMap<String, PropertiesConfiguration>();
    private static final PropertiesConfiguration ENTIRE = new PropertiesConfiguration();

    private PropertiesConfiguration() {
    }

    public static PropertiesConfiguration newInstance(String locationPattern) {
        String key = PropertiesConfiguration.getKey(locationPattern);
        if (!properties.containsKey(key) || properties.get(key) == null) {
            PropertiesConfiguration pc = PropertiesConfiguration.makeInstance(locationPattern);
            properties.put(key, pc);
        }
        return properties.get(key);
    }

    public static void load(String[] locationPatterns) {
        for (String pattern : locationPatterns) {
            String key = PropertiesConfiguration.getKey(pattern);
            if (properties.containsKey(key)) continue;
            PropertiesConfiguration pc = PropertiesConfiguration.makeInstance(pattern);
            properties.put(key, pc);
        }
    }

    public static void clean() {
        ENTIRE.clear();
        for (PropertiesConfiguration conf : properties.values()) {
            conf.clear();
        }
    }

    private static void merge(PropertiesConfiguration target) {
        for (Map.Entry<Object, Object> entry : target.entrySet()) {
            ENTIRE.put(entry.getKey(), entry.getValue());
        }
    }

    public static PropertiesConfiguration get(String name) throws IllegalAccessException {
        if (!properties.containsKey(name)) {
            throw new IllegalAccessException("[" + name + "]\u6ca1\u6709\u88ab\u52a0\u8f7d\u3002");
        }
        return properties.get(name);
    }

    private static PropertiesConfiguration makeInstance(String name) {
        try {
            PropertiesConfiguration pro = new PropertiesConfiguration(name);
            PropertiesConfiguration.merge(pro);
            return pro;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertiesConfiguration(String locationPattern) throws IOException, URISyntaxException {
        String path = "";
        InputStreamReader is = null;
        try {
            path = PathUtils.getRealPath(locationPattern);
            is = new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8");
            this.load(is);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public String getString(String propertyName, String defaultVal) {
        String value = this.getString(propertyName);
        if (value == null) {
            return defaultVal;
        }
        return value;
    }

    public int getInt(String propertyName, int defaultVal) {
        try {
            String tmp = this.getString(propertyName);
            if (tmp == null) {
                return defaultVal;
            }
            int value = Integer.parseInt(tmp);
            return value;
        }
        catch (Exception e) {
            return defaultVal;
        }
    }

    public double getDouble(String propertyName, double defaultVal) {
        try {
            String tmp = this.getString(propertyName);
            if (tmp == null) {
                return defaultVal;
            }
            double value = Double.parseDouble(tmp);
            return value;
        }
        catch (Exception e) {
            return defaultVal;
        }
    }

    public long getLong(String propertyName, long defaultVal) {
        try {
            String tmp = this.getString(propertyName);
            if (tmp == null) {
                return defaultVal;
            }
            long value = Long.parseLong(tmp);
            return value;
        }
        catch (Exception e) {
            return defaultVal;
        }
    }

    public boolean getBoolean(String propertyName, Boolean defaultVal) {
        try {
            String tmp = this.getString(propertyName);
            if (tmp == null) {
                return defaultVal;
            }
            boolean value = Boolean.parseBoolean(tmp);
            return value;
        }
        catch (Exception e) {
            return defaultVal;
        }
    }

    private String getString(String propertyName) {
        return this.getProperty(propertyName);
    }

    private static String getKey(String locationPattern) {
        URL url = null;
        try {
            url = ResourceUtils.loadResource(locationPattern);
            File file = new File(url.getFile());
            return file.getName().substring(0, file.getName().indexOf("."));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getValue(String propertyName, String defaultVal) {
        return ENTIRE.getString(propertyName, defaultVal);
    }

    public static int getValue(String propertyName, int defaultVal) {
        return ENTIRE.getInt(propertyName, defaultVal);
    }

    public static long getValue(String propertyName, long defaultVal) {
        return ENTIRE.getLong(propertyName, defaultVal);
    }

    public static double getValue(String propertyName, double defaultVal) {
        return ENTIRE.getDouble(propertyName, defaultVal);
    }

    public static boolean getValue(String propertyName, boolean defaultVal) {
        return ENTIRE.getBoolean(propertyName, defaultVal);
    }
}

