/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.common.configure;

import com.bfd.harpc.common.configure.PathUtils;
import com.bfd.harpc.common.configure.ResourceConstants;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import org.apache.commons.lang.ArrayUtils;

public class ResourceUtils {
    private static final Object SYS_OBJECT = new Object();
    private static ClassLoader classLoader;

    public static URL loadResource(String locationPattern) throws IOException, URISyntaxException {
        Object[] urlArray = ResourceUtils.loadResources(locationPattern);
        return ArrayUtils.isEmpty((Object[])urlArray) ? null : urlArray[0];
    }

    public static URL[] loadResources(String locationPattern) throws IOException, URISyntaxException {
        if (locationPattern.startsWith(ResourceConstants.CLASSPATH_ALL_URL_PREFIX.getValue())) {
            return ResourceUtils.load1(locationPattern);
        }
        if (locationPattern.startsWith(ResourceConstants.CLASSPATH_URL_PREFIX.getValue())) {
            return ResourceUtils.load2(locationPattern);
        }
        if (locationPattern.startsWith(ResourceConstants.FILE_URL_PREFIX.getValue())) {
            return ResourceUtils.load3(locationPattern);
        }
        locationPattern = "file:" + locationPattern;
        return ResourceUtils.loadResources(locationPattern);
    }

    private static URL[] load1(String locationPattern) throws IOException, URISyntaxException {
        String location = locationPattern.substring(ResourceConstants.CLASSPATH_ALL_URL_PREFIX.getValue().length());
        if (location.startsWith(ResourceConstants.FOLDER_SEPARATOR.getValue())) {
            location = location.substring(1);
        }
        Enumeration<URL> resourceUrls = ResourceUtils.getDefaultClassLoader().getResources(location);
        LinkedHashSet<URL> result = new LinkedHashSet<URL>(16);
        while (resourceUrls.hasMoreElements()) {
            URL url = resourceUrls.nextElement();
            result.add(PathUtils.cleanPath(url));
        }
        return result.toArray(new URL[result.size()]);
    }

    private static URL[] load2(String locationPattern) throws URISyntaxException, IOException {
        URL[] uRLArray;
        String location = locationPattern.substring(ResourceConstants.CLASSPATH_URL_PREFIX.getValue().length());
        if (location.startsWith(ResourceConstants.FOLDER_SEPARATOR.getValue())) {
            location = location.substring(1);
        }
        String cleanPath = PathUtils.cleanPath(location);
        URL url = ResourceUtils.getDefaultClassLoader().getResource(cleanPath);
        if (url == null) {
            uRLArray = null;
        } else {
            URL[] uRLArray2 = new URL[1];
            uRLArray = uRLArray2;
            uRLArray2[0] = PathUtils.cleanPath(url);
        }
        return uRLArray;
    }

    private static URL[] load3(String locationPattern) throws MalformedURLException {
        URL[] uRLArray;
        URL url = new URL(locationPattern);
        if (new File(url.getFile()).exists()) {
            URL[] uRLArray2 = new URL[1];
            uRLArray = uRLArray2;
            uRLArray2[0] = url;
        } else {
            uRLArray = null;
        }
        return uRLArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getDefaultClassLoader() {
        if (classLoader != null) {
            return classLoader;
        }
        Object object = SYS_OBJECT;
        synchronized (object) {
            if (classLoader == null) {
                ClassLoader tempClassLoader = null;
                try {
                    tempClassLoader = Thread.currentThread().getContextClassLoader();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (tempClassLoader == null) {
                    tempClassLoader = ResourceUtils.class.getClassLoader();
                }
                classLoader = tempClassLoader;
            }
        }
        return classLoader;
    }
}

