/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.config;

import com.alibaba.fastjson.JSON;
import com.bfd.harpc.RpcException;
import com.bfd.harpc.client.DefaultInvoker;
import com.bfd.harpc.common.NetUtils;
import com.bfd.harpc.common.ServerNode;
import com.bfd.harpc.config.IConfigCheck;
import com.bfd.harpc.config.RegistryConfig;
import com.bfd.harpc.heartbeat.HeartBeatManager;
import com.bfd.harpc.loadbalance.LoadBalancer;
import com.bfd.harpc.loadbalance.LoadBalancerFactory;
import com.bfd.harpc.loadbalance.common.DynamicHostSet;
import com.bfd.harpc.monitor.RpcMonitor;
import com.bfd.harpc.pool.AvroClientPoolFactory;
import com.bfd.harpc.pool.TServiceClientPoolFactory;
import com.bfd.harpc.proxy.DynamicClientHandler;
import com.bfd.harpc.registry.DefaultRegistry;
import com.bfd.harpc.registry.IRegistry;
import com.bfd.harpc.registry.ZkClientRegistry;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.TServiceClientFactory;

public class ClientConfig<T>
implements IConfigCheck {
    private String name;
    private String owner;
    private String service;
    private String address;
    private int retry = 1;
    private String iface;
    private String protocol = "thrift";
    private boolean monitor;
    private int interval = 300;
    private String loadbalance = "round";
    private int timeout = 3000;
    private int maxActive = 1024;
    private int maxIdle = 100;
    private int minIdle = 0;
    private int maxWait = 2000;
    private int timeBetweenEvictionRunsMillis = 180000;
    private boolean testWhileIdle = false;
    private int heartbeat = 10000;
    private int heartbeatTimeout = 3000;
    private int heartbeatTimes = 3;
    private int heartbeatInterval = 3000;
    private IRegistry registry;
    private RpcMonitor rpcMonitor;
    private HeartBeatManager<T> heartBeatManager;
    private GenericKeyedObjectPool<ServerNode, T> pool;

    public T createProxy(RegistryConfig registryConfig) throws Exception {
        IRegistry registry;
        this.check();
        ServerNode clientNode = new ServerNode(NetUtils.getLocalHost(), 0);
        if (this.getAddress() != null) {
            registry = new DefaultRegistry(this.getAddress());
        } else if (registryConfig != null) {
            registry = new ZkClientRegistry(this.service, registryConfig.obtainZkClient(), clientNode);
        } else {
            throw new RpcException(5, "The params 'addess' and '<registry>' node cannot all unexist!");
        }
        registry.register(this.genConfigJson());
        RpcMonitor rpcMonitor = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> objectClass = classLoader.loadClass(this.iface);
        GenericKeyedObjectPool<ServerNode, T> pool = this.bulidClientPool(classLoader, objectClass);
        DynamicHostSet hostSet = registry.findAllService();
        HeartBeatManager<T> heartBeatManager = new HeartBeatManager<T>(hostSet, this.heartbeat, this.heartbeatTimeout, this.heartbeatTimes, this.heartbeatInterval, pool);
        heartBeatManager.startHeatbeatTimer();
        this.registry = registry;
        this.rpcMonitor = rpcMonitor;
        this.heartBeatManager = heartBeatManager;
        this.pool = pool;
        this.addShutdownHook(registry, rpcMonitor, heartBeatManager);
        LoadBalancer<ServerNode> loadBalancer = LoadBalancerFactory.createLoadBalancer(registry.findAllService(), this.loadbalance, heartBeatManager);
        DefaultInvoker<T> invoker = new DefaultInvoker<T>(clientNode, pool, loadBalancer, this.retry, rpcMonitor, hostSet);
        DynamicClientHandler dynamicClientHandler = new DynamicClientHandler(invoker);
        return dynamicClientHandler.bind(classLoader, objectClass);
    }

    protected GenericKeyedObjectPool<ServerNode, T> bulidClientPool(ClassLoader classLoader, Class<?> ifaceClass) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        GenericKeyedObjectPool.Config poolConfig = new GenericKeyedObjectPool.Config();
        poolConfig.maxActive = this.maxActive;
        poolConfig.maxIdle = this.maxIdle;
        poolConfig.minIdle = this.minIdle;
        poolConfig.maxWait = this.maxWait;
        poolConfig.timeBetweenEvictionRunsMillis = this.timeBetweenEvictionRunsMillis;
        poolConfig.testWhileIdle = this.testWhileIdle;
        if (StringUtils.equalsIgnoreCase((String)this.protocol, (String)"thrift")) {
            Class<?> fi = classLoader.loadClass(this.findOutClassName() + "$Client$Factory");
            TServiceClientFactory clientFactory = (TServiceClientFactory)fi.newInstance();
            TServiceClientPoolFactory clientPool = new TServiceClientPoolFactory((TServiceClientFactory<TServiceClient>)clientFactory, this.timeout);
            return new GenericKeyedObjectPool(clientPool, poolConfig);
        }
        if (StringUtils.equalsIgnoreCase((String)this.protocol, (String)"avro")) {
            AvroClientPoolFactory clientPool = new AvroClientPoolFactory(this.timeout, ifaceClass);
            return new GenericKeyedObjectPool(clientPool, poolConfig);
        }
        throw new RpcException(5, "Unsupport protocal,please check the params 'protocal'!");
    }

    private String findOutClassName() {
        if (this.iface.contains("$")) {
            return this.iface.substring(0, this.iface.indexOf("$"));
        }
        return this.iface;
    }

    @Override
    public void check() throws RpcException {
        if (StringUtils.isEmpty((String)this.service)) {
            throw new RpcException(5, "The params 'service' cannot empty!");
        }
        if (StringUtils.isEmpty((String)this.iface)) {
            throw new RpcException(5, "The params 'iface' cannot empty!");
        }
        if (this.interval < 60) {
            throw new RpcException(5, "The params 'interval' must >= 60!");
        }
        if (this.heartbeat < 1000) {
            throw new RpcException(5, "The params 'heartbeat' must >= 1000!");
        }
    }

    public void destory() {
        if (this.rpcMonitor != null) {
            this.rpcMonitor.destroy();
        }
        if (this.registry != null) {
            this.registry.unregister();
        }
        if (this.heartBeatManager != null) {
            this.heartBeatManager.stopHeartbeatTimer();
        }
        if (this.pool != null) {
            this.pool.clear();
        }
    }

    protected String genConfigJson() {
        return JSON.toJSONString((Object)this);
    }

    protected void addShutdownHook(final IRegistry registry, final RpcMonitor monitor, final HeartBeatManager<T> heartBeatManager) {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (monitor != null) {
                    monitor.destroy();
                }
                if (registry != null) {
                    registry.unregister();
                }
                if (heartBeatManager != null) {
                    heartBeatManager.stopHeartbeatTimer();
                }
                if (ClientConfig.this.pool != null) {
                    ClientConfig.this.pool.clear();
                }
            }
        }));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public int getRetry() {
        return this.retry;
    }

    public void setRetry(int retry) {
        this.retry = retry;
    }

    public String getIface() {
        return this.iface;
    }

    public void setIface(String iface) {
        this.iface = iface;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public boolean isMonitor() {
        return this.monitor;
    }

    public void setMonitor(boolean monitor) {
        this.monitor = monitor;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public String getLoadbalance() {
        return this.loadbalance;
    }

    public void setLoadbalance(String loadbalance) {
        this.loadbalance = loadbalance;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public int getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(int maxWait) {
        this.maxWait = maxWait;
    }

    public int getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(int timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public int getHeartbeat() {
        return this.heartbeat;
    }

    public void setHeartbeat(int heartbeat) {
        this.heartbeat = heartbeat;
    }

    public int getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public void setHeartbeatTimeout(int heartbeatTimeout) {
        this.heartbeatTimeout = heartbeatTimeout;
    }

    public int getHeartbeatTimes() {
        return this.heartbeatTimes;
    }

    public void setHeartbeatTimes(int heartbeatTimes) {
        this.heartbeatTimes = heartbeatTimes;
    }

    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setHeartbeatInterval(int heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }
}

